/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor.multicriteria;

import java.util.BitSet;
import java.util.Collections;
import org.opentripplanner.transit.raptor.api.response.StopArrivals;
import org.opentripplanner.transit.raptor.api.transit.IntIterator;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.transit.raptor.api.view.ArrivalView;
import org.opentripplanner.transit.raptor.rangeraptor.debug.DebugHandlerFactory;
import org.opentripplanner.transit.raptor.rangeraptor.multicriteria.DebugStopArrivalsStatistics;
import org.opentripplanner.transit.raptor.rangeraptor.multicriteria.StopArrivalParetoSet;
import org.opentripplanner.transit.raptor.rangeraptor.multicriteria.arrivals.AbstractStopArrival;
import org.opentripplanner.transit.raptor.rangeraptor.path.DestinationArrivalPaths;
import org.opentripplanner.transit.raptor.rangeraptor.transit.EgressPaths;
import org.opentripplanner.transit.raptor.util.BitSetIterator;

public final class McStopArrivals<T extends RaptorTripSchedule>
implements StopArrivals {
    private final StopArrivalParetoSet<T>[] arrivals;
    private final BitSet touchedStops;
    private final DebugHandlerFactory<T> debugHandlerFactory;
    private final DebugStopArrivalsStatistics debugStats;

    public McStopArrivals(int nStops, EgressPaths egressPaths, DestinationArrivalPaths<T> paths, DebugHandlerFactory<T> debugHandlerFactory) {
        this.arrivals = new StopArrivalParetoSet[nStops];
        this.touchedStops = new BitSet(nStops);
        this.debugHandlerFactory = debugHandlerFactory;
        this.debugStats = new DebugStopArrivalsStatistics(debugHandlerFactory.debugLogger());
        this.glueTogetherEgressStopWithDestinationArrivals(egressPaths, paths);
    }

    @Override
    public boolean reached(int stopIndex) {
        return this.arrivals[stopIndex] != null && !this.arrivals[stopIndex].isEmpty();
    }

    @Override
    public int bestArrivalTime(int stopIndex) {
        return this.arrivals[stopIndex].stream().mapToInt(AbstractStopArrival::arrivalTime).min().orElseThrow();
    }

    @Override
    public boolean reachedByTransit(int stopIndex) {
        return this.arrivals[stopIndex] != null && this.arrivals[stopIndex].stream().anyMatch(ArrivalView::arrivedByTransit);
    }

    @Override
    public int bestTransitArrivalTime(int stopIndex) {
        return this.arrivals[stopIndex].stream().filter(ArrivalView::arrivedByTransit).mapToInt(AbstractStopArrival::arrivalTime).min().orElseThrow();
    }

    @Override
    public int smallestNumberOfTransfers(int stopIndex) {
        return this.arrivals[stopIndex].stream().filter(ArrivalView::arrivedByTransit).mapToInt(ArrivalView::numberOfTransfers).min().orElseThrow();
    }

    boolean updateExist() {
        return !this.touchedStops.isEmpty();
    }

    IntIterator stopsTouchedIterator() {
        return new BitSetIterator(this.touchedStops);
    }

    void addStopArrival(AbstractStopArrival<T> arrival) {
        boolean added = this.findOrCreateSet(arrival.stop()).add(arrival);
        if (added) {
            this.touchedStops.set(arrival.stop());
        }
    }

    void debugStateInfo() {
        this.debugStats.debugStatInfo(this.arrivals);
    }

    Iterable<AbstractStopArrival<T>> listArrivalsAfterMarker(int stop) {
        StopArrivalParetoSet<T> it = this.arrivals[stop];
        if (it == null) {
            return Collections::emptyIterator;
        }
        return it.elementsAfterMarker();
    }

    void clearTouchedStopsAndSetStopMarkers() {
        IntIterator it = this.stopsTouchedIterator();
        while (it.hasNext()) {
            this.arrivals[it.next()].markAtEndOfSet();
        }
        this.touchedStops.clear();
    }

    private StopArrivalParetoSet<T> findOrCreateSet(int stop) {
        if (this.arrivals[stop] == null) {
            this.arrivals[stop] = StopArrivalParetoSet.createStopArrivalSet(stop, this.debugHandlerFactory);
        }
        return this.arrivals[stop];
    }

    private void glueTogetherEgressStopWithDestinationArrivals(EgressPaths egressPaths, DestinationArrivalPaths<T> paths) {
        egressPaths.byStop().forEachEntry((stop, list) -> {
            this.arrivals[stop] = StopArrivalParetoSet.createEgressStopArrivalSet(stop, list, paths, this.debugHandlerFactory);
            return true;
        });
    }
}

