/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor.multicriteria;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.opentripplanner.transit.raptor.api.path.Path;
import org.opentripplanner.transit.raptor.api.response.StopArrivals;
import org.opentripplanner.transit.raptor.api.transit.CostCalculator;
import org.opentripplanner.transit.raptor.api.transit.IntIterator;
import org.opentripplanner.transit.raptor.api.transit.RaptorAccessEgress;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransfer;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.transit.raptor.rangeraptor.internalapi.WorkerLifeCycle;
import org.opentripplanner.transit.raptor.rangeraptor.internalapi.WorkerState;
import org.opentripplanner.transit.raptor.rangeraptor.multicriteria.McStopArrivals;
import org.opentripplanner.transit.raptor.rangeraptor.multicriteria.PatternRide;
import org.opentripplanner.transit.raptor.rangeraptor.multicriteria.arrivals.AbstractStopArrival;
import org.opentripplanner.transit.raptor.rangeraptor.multicriteria.arrivals.AccessStopArrival;
import org.opentripplanner.transit.raptor.rangeraptor.multicriteria.arrivals.TransferStopArrival;
import org.opentripplanner.transit.raptor.rangeraptor.multicriteria.arrivals.TransitStopArrival;
import org.opentripplanner.transit.raptor.rangeraptor.multicriteria.heuristic.HeuristicsProvider;
import org.opentripplanner.transit.raptor.rangeraptor.path.DestinationArrivalPaths;
import org.opentripplanner.transit.raptor.rangeraptor.transit.TransitCalculator;

public final class McRangeRaptorWorkerState<T extends RaptorTripSchedule>
implements WorkerState<T> {
    private final McStopArrivals<T> arrivals;
    private final DestinationArrivalPaths<T> paths;
    private final HeuristicsProvider<T> heuristics;
    private final List<AbstractStopArrival<T>> arrivalsCache = new ArrayList<AbstractStopArrival<T>>();
    private final CostCalculator<T> costCalculator;
    private final TransitCalculator<T> transitCalculator;

    public McRangeRaptorWorkerState(McStopArrivals<T> arrivals, DestinationArrivalPaths<T> paths, HeuristicsProvider<T> heuristics, CostCalculator<T> costCalculator, TransitCalculator<T> transitCalculator, WorkerLifeCycle lifeCycle) {
        this.arrivals = arrivals;
        this.paths = paths;
        this.heuristics = heuristics;
        this.costCalculator = costCalculator;
        this.transitCalculator = transitCalculator;
        lifeCycle.onSetupIteration(ignore -> this.setupIteration());
        lifeCycle.onTransitsForRoundComplete(this::transitsForRoundComplete);
        lifeCycle.onTransfersForRoundComplete(this::transfersForRoundComplete);
    }

    @Override
    public boolean isNewRoundAvailable() {
        return this.arrivals.updateExist();
    }

    @Override
    public IntIterator stopsTouchedPreviousRound() {
        return this.arrivals.stopsTouchedIterator();
    }

    @Override
    public IntIterator stopsTouchedByTransitCurrentRound() {
        return this.arrivals.stopsTouchedIterator();
    }

    @Override
    public boolean isDestinationReachedInCurrentRound() {
        return this.paths.isReachedCurrentRound();
    }

    @Override
    public void setAccessToStop(RaptorAccessEgress accessPath, int departureTime) {
        this.addStopArrival(new AccessStopArrival(departureTime, accessPath));
    }

    @Override
    public void transferToStops(int fromStop, Iterator<? extends RaptorTransfer> transfers) {
        Iterable<AbstractStopArrival<T>> fromArrivals = this.arrivals.listArrivalsAfterMarker(fromStop);
        while (transfers.hasNext()) {
            this.transferToStop(fromArrivals, transfers.next());
        }
    }

    @Override
    public Collection<Path<T>> extractPaths() {
        this.arrivals.debugStateInfo();
        return this.paths.listPaths();
    }

    @Override
    public StopArrivals extractStopArrivals() {
        return this.arrivals;
    }

    Iterable<? extends AbstractStopArrival<T>> listStopArrivalsPreviousRound(int stop) {
        return this.arrivals.listArrivalsAfterMarker(stop);
    }

    void transitToStop(PatternRide<T> ride, int alightStop, int alightTime, int alightSlack) {
        int stopArrivalTime = alightTime + alightSlack;
        if (this.exceedsTimeLimit(stopArrivalTime)) {
            return;
        }
        int costTransit = this.costCalculator.transitArrivalCost(ride.boardCost(), alightSlack, alightTime - ride.boardTime(), ride.trip(), alightStop);
        this.arrivalsCache.add(new TransitStopArrival<T>(ride.prevArrival(), alightStop, stopArrivalTime, costTransit, ride.trip()));
    }

    private void setupIteration() {
        this.arrivalsCache.clear();
        this.arrivals.clearTouchedStopsAndSetStopMarkers();
    }

    private void transitsForRoundComplete() {
        this.arrivals.clearTouchedStopsAndSetStopMarkers();
        this.commitCachedArrivals();
    }

    private void transfersForRoundComplete() {
        this.commitCachedArrivals();
    }

    private void transferToStop(Iterable<? extends AbstractStopArrival<T>> fromArrivals, RaptorTransfer transfer) {
        int transferTimeInSeconds = transfer.durationInSeconds();
        for (AbstractStopArrival<T> it : fromArrivals) {
            int arrivalTime = it.arrivalTime() + transferTimeInSeconds;
            if (this.exceedsTimeLimit(arrivalTime)) continue;
            this.arrivalsCache.add(new TransferStopArrival<T>(it, transfer, arrivalTime));
        }
    }

    private void commitCachedArrivals() {
        for (AbstractStopArrival<T> arrival : this.arrivalsCache) {
            this.addStopArrival(arrival);
        }
        this.arrivalsCache.clear();
    }

    private void addStopArrival(AbstractStopArrival<T> arrival) {
        if (this.heuristics.rejectDestinationArrivalBasedOnHeuristic(arrival)) {
            return;
        }
        this.arrivals.addStopArrival(arrival);
    }

    private boolean exceedsTimeLimit(int time) {
        return this.transitCalculator.exceedsTimeLimit(time);
    }
}

