/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor.multicriteria;

import java.util.List;
import org.opentripplanner.transit.raptor.api.transit.RaptorAccessEgress;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.transit.raptor.api.view.ArrivalView;
import org.opentripplanner.transit.raptor.rangeraptor.path.DestinationArrivalPaths;
import org.opentripplanner.transit.raptor.util.paretoset.ParetoSetEventListener;

public class CalculateTransferToDestination<T extends RaptorTripSchedule>
implements ParetoSetEventListener<ArrivalView<T>> {
    private final List<RaptorAccessEgress> egressPaths;
    private final DestinationArrivalPaths<T> destinationArrivals;

    CalculateTransferToDestination(List<RaptorAccessEgress> egressPaths, DestinationArrivalPaths<T> destinationArrivals) {
        this.egressPaths = egressPaths;
        this.destinationArrivals = destinationArrivals;
    }

    @Override
    public void notifyElementAccepted(ArrivalView<T> newElement) {
        block3: {
            block2: {
                if (!newElement.arrivedByTransit()) break block2;
                for (RaptorAccessEgress egress : this.egressPaths) {
                    this.destinationArrivals.add(newElement, egress);
                }
                break block3;
            }
            if (!newElement.arrivedByTransfer()) break block3;
            for (RaptorAccessEgress egress : this.egressPaths) {
                if (!egress.stopReachedOnBoard()) continue;
                this.destinationArrivals.add(newElement, egress);
            }
        }
    }
}

