/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor.debug;

import javax.annotation.Nullable;
import org.opentripplanner.transit.raptor.api.debug.DebugLogger;
import org.opentripplanner.transit.raptor.api.path.Path;
import org.opentripplanner.transit.raptor.api.request.DebugRequest;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.transit.raptor.api.view.ArrivalView;
import org.opentripplanner.transit.raptor.api.view.PatternRideView;
import org.opentripplanner.transit.raptor.rangeraptor.debug.DebugHandlerPathAdapter;
import org.opentripplanner.transit.raptor.rangeraptor.debug.DebugHandlerPatternRideAdapter;
import org.opentripplanner.transit.raptor.rangeraptor.debug.DebugHandlerStopArrivalAdapter;
import org.opentripplanner.transit.raptor.rangeraptor.debug.ParetoSetDebugHandlerAdapter;
import org.opentripplanner.transit.raptor.rangeraptor.internalapi.DebugHandler;
import org.opentripplanner.transit.raptor.rangeraptor.internalapi.WorkerLifeCycle;
import org.opentripplanner.transit.raptor.util.paretoset.ParetoSetEventListener;

public class DebugHandlerFactory<T extends RaptorTripSchedule> {
    private final DebugHandler<ArrivalView<?>> stopHandler;
    private final DebugHandler<Path<?>> pathHandler;
    private final DebugHandler<PatternRideView<?>> patternRideHandler;
    private final DebugLogger logger;

    public DebugHandlerFactory(DebugRequest request, WorkerLifeCycle lifeCycle) {
        this.stopHandler = this.isDebug(request.stopArrivalListener()) ? new DebugHandlerStopArrivalAdapter(request, lifeCycle) : null;
        this.pathHandler = this.isDebug(request.pathFilteringListener()) ? new DebugHandlerPathAdapter(request, lifeCycle) : null;
        this.patternRideHandler = this.isDebug(request.patternRideDebugListener()) ? new DebugHandlerPatternRideAdapter(request, lifeCycle) : null;
        this.logger = request.logger();
        lifeCycle.onRouteSearch(this.logger::setSearchDirection);
    }

    public boolean isDebugStopArrival() {
        return this.isDebug(this.stopHandler);
    }

    public DebugHandler<ArrivalView<?>> debugStopArrival() {
        return this.stopHandler;
    }

    @Nullable
    public ParetoSetEventListener<ArrivalView<T>> paretoSetStopArrivalListener(int stop) {
        return this.isDebugStopArrival(stop) ? new ParetoSetDebugHandlerAdapter(this.stopHandler) : null;
    }

    public boolean isDebugStopArrival(int stop) {
        return this.stopHandler != null && this.stopHandler.isDebug(stop);
    }

    @Nullable
    public ParetoSetEventListener<PatternRideView<?>> paretoSetPatternRideListener() {
        return this.patternRideHandler == null ? null : new ParetoSetDebugHandlerAdapter(this.patternRideHandler);
    }

    @Nullable
    public ParetoSetDebugHandlerAdapter<Path<?>> paretoSetDebugPathListener() {
        return this.pathHandler == null ? null : new ParetoSetDebugHandlerAdapter(this.pathHandler);
    }

    @Nullable
    public DebugHandler<Path<?>> debugPathArrival() {
        return this.pathHandler;
    }

    public DebugLogger debugLogger() {
        return this.logger;
    }

    private boolean isDebug(Object handler) {
        return handler != null;
    }
}

