/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor.context;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import org.opentripplanner.transit.raptor.api.debug.RaptorTimers;
import org.opentripplanner.transit.raptor.api.request.DebugRequest;
import org.opentripplanner.transit.raptor.api.request.RaptorProfile;
import org.opentripplanner.transit.raptor.api.request.RaptorRequest;
import org.opentripplanner.transit.raptor.api.request.RaptorTuningParameters;
import org.opentripplanner.transit.raptor.api.request.SearchParams;
import org.opentripplanner.transit.raptor.api.transit.CostCalculator;
import org.opentripplanner.transit.raptor.api.transit.RaptorAccessEgress;
import org.opentripplanner.transit.raptor.api.transit.RaptorSlackProvider;
import org.opentripplanner.transit.raptor.api.transit.RaptorStopNameResolver;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransitDataProvider;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripPattern;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.transit.raptor.api.transit.SearchDirection;
import org.opentripplanner.transit.raptor.rangeraptor.debug.DebugHandlerFactory;
import org.opentripplanner.transit.raptor.rangeraptor.internalapi.RoundProvider;
import org.opentripplanner.transit.raptor.rangeraptor.internalapi.SlackProvider;
import org.opentripplanner.transit.raptor.rangeraptor.internalapi.WorkerLifeCycle;
import org.opentripplanner.transit.raptor.rangeraptor.lifecycle.LifeCycleEventPublisher;
import org.opentripplanner.transit.raptor.rangeraptor.lifecycle.LifeCycleSubscriptions;
import org.opentripplanner.transit.raptor.rangeraptor.transit.AccessPaths;
import org.opentripplanner.transit.raptor.rangeraptor.transit.EgressPaths;
import org.opentripplanner.transit.raptor.rangeraptor.transit.ForwardTransitCalculator;
import org.opentripplanner.transit.raptor.rangeraptor.transit.ReverseTransitCalculator;
import org.opentripplanner.transit.raptor.rangeraptor.transit.RoundTracker;
import org.opentripplanner.transit.raptor.rangeraptor.transit.SlackProviderAdapter;
import org.opentripplanner.transit.raptor.rangeraptor.transit.TransitCalculator;

public class SearchContext<T extends RaptorTripSchedule> {
    private final RaptorRequest<T> request;
    protected final RaptorTransitDataProvider<T> transit;
    private final TransitCalculator<T> calculator;
    private final CostCalculator<T> costCalculator;
    private final RaptorTuningParameters tuningParameters;
    private final RoundTracker roundTracker;
    private final DebugHandlerFactory<T> debugFactory;
    private final EgressPaths egressPaths;
    private final AccessPaths accessPaths;
    private final LifeCycleSubscriptions lifeCycleSubscriptions = new LifeCycleSubscriptions();

    public SearchContext(RaptorRequest<T> request, RaptorTuningParameters tuningParameters, RaptorTransitDataProvider<T> transit) {
        this.request = request;
        this.tuningParameters = tuningParameters;
        this.transit = transit;
        this.accessPaths = SearchContext.accessPaths(request);
        this.egressPaths = SearchContext.egressPaths(request);
        this.calculator = SearchContext.createCalculator(this.request, tuningParameters);
        this.costCalculator = request.profile().is(RaptorProfile.MULTI_CRITERIA) ? transit.multiCriteriaCostCalculator() : null;
        this.roundTracker = new RoundTracker(this.nRounds(), request.searchParams().numberOfAdditionalTransfers(), this.lifeCycle());
        this.debugFactory = new DebugHandlerFactory(SearchContext.debugRequest(request), this.lifeCycle());
    }

    public AccessPaths accessPaths() {
        return this.accessPaths;
    }

    public EgressPaths egressPaths() {
        return this.egressPaths;
    }

    public int[] egressStops() {
        return this.egressPaths().stops();
    }

    public SearchParams searchParams() {
        return this.request.searchParams();
    }

    public RaptorProfile profile() {
        return this.request.profile();
    }

    public SearchDirection searchDirection() {
        return this.request.searchDirection();
    }

    public RaptorTransitDataProvider<T> transit() {
        return this.transit;
    }

    public TransitCalculator<T> calculator() {
        return this.calculator;
    }

    public SlackProvider slackProvider() {
        return SearchContext.createSlackProvider(this.request, this.lifeCycle());
    }

    public RaptorSlackProvider raptorSlackProvider() {
        return this.request.slackProvider();
    }

    public ToIntFunction<RaptorTripPattern> boardSlackProvider() {
        return SearchContext.createBoardSlackProvider(this.request);
    }

    @Nullable
    public CostCalculator<T> costCalculator() {
        return this.costCalculator;
    }

    public DebugHandlerFactory<T> debugFactory() {
        return this.debugFactory;
    }

    public RaptorTimers performanceTimers() {
        return this.request.performanceTimers();
    }

    public int nStops() {
        return this.transit.numberOfStops();
    }

    public int nRounds() {
        if (this.request.searchParams().isMaxNumberOfTransfersSet()) {
            return this.request.searchParams().maxNumberOfTransfers() + 1;
        }
        return this.tuningParameters.maxNumberOfTransfers() + 1;
    }

    public RoundProvider roundProvider() {
        return this.roundTracker;
    }

    public WorkerLifeCycle lifeCycle() {
        return this.lifeCycleSubscriptions;
    }

    public LifeCycleEventPublisher createLifeCyclePublisher() {
        LifeCycleEventPublisher publisher = new LifeCycleEventPublisher(this.lifeCycleSubscriptions);
        this.lifeCycleSubscriptions.close();
        return publisher;
    }

    public boolean enableConstrainedTransfers() {
        return this.searchParams().constrainedTransfersEnabled();
    }

    public RaptorStopNameResolver stopNameResolver() {
        return this.transit.stopNameResolver();
    }

    static Collection<RaptorAccessEgress> accessOrEgressPaths(boolean getAccess, RaptorProfile profile, SearchParams searchParams) {
        Collection<RaptorAccessEgress> paths;
        Collection<RaptorAccessEgress> collection = paths = getAccess ? searchParams.accessPaths() : searchParams.egressPaths();
        if (profile.is(RaptorProfile.MULTI_CRITERIA)) {
            return paths;
        }
        HashMap<Integer, RaptorAccessEgress> bestTimePaths = new HashMap<Integer, RaptorAccessEgress>();
        for (RaptorAccessEgress it : paths) {
            RaptorAccessEgress existing = (RaptorAccessEgress)bestTimePaths.get(it.stop());
            if (existing != null && it.durationInSeconds() >= existing.durationInSeconds()) continue;
            bestTimePaths.put(it.stop(), it);
        }
        return List.copyOf(bestTimePaths.values());
    }

    private static <T extends RaptorTripSchedule> TransitCalculator<T> createCalculator(RaptorRequest<T> r, RaptorTuningParameters t) {
        SearchParams s = r.searchParams();
        return r.searchDirection().isForward() ? new ForwardTransitCalculator(s, t) : new ReverseTransitCalculator(s, t);
    }

    private static DebugRequest debugRequest(RaptorRequest<?> request) {
        return request.searchDirection().isForward() ? request.debug() : request.mutate().debug().reverseDebugRequest().build();
    }

    private static SlackProvider createSlackProvider(RaptorRequest<?> request, WorkerLifeCycle lifeCycle) {
        return request.searchDirection().isForward() ? SlackProviderAdapter.forwardSlackProvider(request.slackProvider(), lifeCycle) : SlackProviderAdapter.reverseSlackProvider(request.slackProvider(), lifeCycle);
    }

    private static ToIntFunction<RaptorTripPattern> createBoardSlackProvider(RaptorRequest<?> request) {
        return request.searchDirection().isForward() ? p -> request.slackProvider().boardSlack(p.slackIndex()) : p -> request.slackProvider().alightSlack(p.slackIndex());
    }

    private static AccessPaths accessPaths(RaptorRequest<?> request) {
        boolean forward = request.searchDirection().isForward();
        SearchParams params = request.searchParams();
        Collection<RaptorAccessEgress> paths = forward ? params.accessPaths() : params.egressPaths();
        return AccessPaths.create(paths, request.profile());
    }

    private static EgressPaths egressPaths(RaptorRequest<?> request) {
        boolean forward = request.searchDirection().isForward();
        SearchParams params = request.searchParams();
        Collection<RaptorAccessEgress> paths = forward ? params.egressPaths() : params.accessPaths();
        return EgressPaths.create(paths, request.profile());
    }
}

