/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor;

import java.text.NumberFormat;
import java.util.Locale;
import javax.annotation.Nullable;
import org.opentripplanner.framework.text.Table;
import org.opentripplanner.transit.raptor.api.debug.DebugEvent;
import org.opentripplanner.transit.raptor.api.debug.DebugLogger;
import org.opentripplanner.transit.raptor.api.debug.DebugTopic;
import org.opentripplanner.transit.raptor.api.path.Path;
import org.opentripplanner.transit.raptor.api.path.PathStringBuilder;
import org.opentripplanner.transit.raptor.api.transit.BoardAndAlightTime;
import org.opentripplanner.transit.raptor.api.view.ArrivalView;
import org.opentripplanner.transit.raptor.api.view.PatternRideView;
import org.opentripplanner.transit.raptor.rangeraptor.transit.TripTimesSearch;
import org.opentripplanner.util.lang.IntUtils;
import org.opentripplanner.util.lang.OtpNumberFormat;
import org.opentripplanner.util.lang.StringUtils;
import org.opentripplanner.util.time.DurationUtils;
import org.opentripplanner.util.time.TimeUtils;

public class SystemErrDebugLogger
implements DebugLogger {
    private static final int NOT_SET = Integer.MIN_VALUE;
    private final boolean enableDebugLogging;
    private final NumberFormat numFormat = NumberFormat.getInstance(Locale.FRANCE);
    private final Table arrivalTable = Table.of().withAlights(Table.Align.Center, Table.Align.Center, Table.Align.Right, Table.Align.Right, Table.Align.Right, Table.Align.Right, Table.Align.Left, Table.Align.Left).withHeaders("ARRIVAL", "LEG", "RND", "STOP", "ARRIVE", "COST", "TRIP", "DETAILS").withMinWidths(9, 7, 3, 5, 8, 9, 24, 0).build();
    private final Table pathTable = Table.of().withAlights(Table.Align.Center, Table.Align.Center, Table.Align.Right, Table.Align.Right, Table.Align.Right, Table.Align.Right, Table.Align.Right, Table.Align.Right, Table.Align.Left).withHeaders(">>> PATH", "TR", "FROM", "TO", "START", "END", "DURATION", "COST", "DETAILS").withMinWidths(9, 2, 5, 5, 8, 8, 8, 6, 0).build();
    private boolean forwardSearch = true;
    private int lastIterationTime = Integer.MIN_VALUE;
    private int lastRound = Integer.MIN_VALUE;
    private boolean printPathHeader = true;

    public SystemErrDebugLogger(boolean enableDebugLogging) {
        this.enableDebugLogging = enableDebugLogging;
    }

    public void stopArrivalLister(DebugEvent<ArrivalView<?>> e) {
        this.printIterationHeader(e.iterationStartTime());
        this.printRoundHeader(e.element().round());
        this.print(e.element(), e.action().toString(), e.reason());
        ArrivalView<?> byElement = e.rejectedDroppedByElement();
        if (e.action() == DebugEvent.Action.DROP && byElement != null) {
            this.print(byElement, "->by", "");
        }
    }

    public void patternRideLister(DebugEvent<PatternRideView<?>> e) {
        this.printIterationHeader(e.iterationStartTime());
        this.printRoundHeader(e.element().prevArrival().round() + 1);
        this.print(e.element(), e.action().toString());
        PatternRideView<?> byElement = e.rejectedDroppedByElement();
        if (e.action() == DebugEvent.Action.DROP && byElement != null) {
            this.print(byElement, "->by");
        }
    }

    public void pathFilteringListener(DebugEvent<Path<?>> e) {
        if (this.printPathHeader) {
            System.err.println();
            System.err.println(this.pathTable.headerRow());
            this.printPathHeader = false;
        }
        Path<?> p = e.element();
        System.err.println(this.pathTable.rowAsText(e.action().toString(), p.numberOfTransfers(), p.accessLeg().toStop(), p.egressLeg().fromStop(), TimeUtils.timeToStrLong(p.accessLeg().fromTime()), TimeUtils.timeToStrLong(p.egressLeg().toTime()), DurationUtils.durationToStr(p.durationInSeconds()), OtpNumberFormat.formatCostCenti(p.generalizedCost()), SystemErrDebugLogger.details(e.action().toString(), e.reason(), e.element().toString())));
    }

    @Override
    public boolean isEnabled() {
        return this.enableDebugLogging;
    }

    @Override
    public void setSearchDirection(boolean forward) {
        this.forwardSearch = forward;
    }

    @Override
    public void debug(DebugTopic topic, String message) {
        if (this.enableDebugLogging) {
            if (message.contains("\n")) {
                System.err.printf("%s\n%s", new Object[]{topic, message});
            } else {
                System.err.printf("%-16s | %s%n", new Object[]{topic, message});
            }
        }
    }

    private static String details(String action, String optReason, @Nullable String element) {
        StringBuilder buf = new StringBuilder();
        buf.append(action).append(": ").append(element);
        if (SystemErrDebugLogger.isNotBlank(optReason)) {
            buf.append("  # ").append(optReason);
        }
        return buf.toString();
    }

    private static int legDuration(ArrivalView<?> a) {
        if (a.arrivedByAccess()) {
            return a.accessPath().access().durationInSeconds();
        }
        if (a.arrivedByTransfer()) {
            return a.transferPath().durationInSeconds();
        }
        if (a.arrivedAtDestination()) {
            return a.egressPath().egress().durationInSeconds();
        }
        throw new IllegalStateException("Unsupported type: " + a.getClass());
    }

    private static boolean isNotBlank(String text) {
        return StringUtils.hasValue(text);
    }

    private void printIterationHeader(int iterationTime) {
        if (iterationTime == this.lastIterationTime) {
            return;
        }
        this.lastIterationTime = iterationTime;
        this.lastRound = Integer.MIN_VALUE;
        this.printPathHeader = true;
        System.err.println("\n**  RUN RAPTOR FOR MINUTE: " + TimeUtils.timeToStrCompact(iterationTime) + "  **");
    }

    private void print(ArrivalView<?> a, String action, String optReason) {
        this.printPathHeader = true;
        String pattern = a.arrivedByTransit() ? a.transitPath().trip().pattern().debugInfo() : "";
        System.err.println(this.arrivalTable.rowAsText(action, this.legType(a), a.round(), IntUtils.intToString(a.stop(), Integer.MIN_VALUE), TimeUtils.timeToStrLong(a.arrivalTime()), this.numFormat.format(a.cost()), pattern, SystemErrDebugLogger.details(action, optReason, this.path(a))));
    }

    private void print(PatternRideView<?> p, String action) {
        System.err.println(this.arrivalTable.rowAsText(action, "OnRide", p.prevArrival().round() + 1, p.boardStopIndex(), TimeUtils.timeToStrLong(p.boardTime()), this.numFormat.format(p.relativeCost()), p.trip().pattern().debugInfo(), p.toString()));
    }

    private String path(ArrivalView<?> a) {
        return this.path(a, new PathStringBuilder(null)).space().space().append("[ ").generalizedCostSentiSec(a.cost()).append(" ]").toString();
    }

    private PathStringBuilder path(ArrivalView<?> a, PathStringBuilder buf) {
        if (a.arrivedByAccess()) {
            return buf.accessEgress(a.accessPath().access()).sep().stop(a.stop());
        }
        this.path(a.previous(), buf);
        buf.sep();
        if (a.arrivedByTransit()) {
            String tripInfo = a.transitPath().trip().pattern().debugInfo();
            if (this.forwardSearch) {
                BoardAndAlightTime t = TripTimesSearch.findTripForwardSearchApproximateTime(a);
                buf.transit(tripInfo, t.boardTime(), t.alightTime());
            } else {
                BoardAndAlightTime t = TripTimesSearch.findTripReverseSearchApproximateTime(a);
                buf.transit(tripInfo, t.alightTime(), t.boardTime());
            }
        } else if (a.arrivedByTransfer()) {
            buf.walk(SystemErrDebugLogger.legDuration(a));
        } else {
            buf.accessEgress(a.egressPath().egress());
        }
        return buf.sep().stop(a.stop());
    }

    private void printRoundHeader(int round) {
        if (round == this.lastRound) {
            return;
        }
        this.lastRound = round;
        System.err.println();
        System.err.println(this.arrivalTable.headerRow());
    }

    private String legType(ArrivalView<?> a) {
        if (a.arrivedByAccess()) {
            return "Access";
        }
        if (a.arrivedByTransit()) {
            return "Transit";
        }
        if (a.arrivedByTransfer()) {
            return "Walk";
        }
        if (a.arrivedAtDestination()) {
            return "Egress";
        }
        throw new IllegalStateException("Unknown mode for: " + this);
    }
}

