/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.configure;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import org.opentripplanner.transit.raptor.api.request.RaptorRequest;
import org.opentripplanner.transit.raptor.api.request.RaptorTuningParameters;
import org.opentripplanner.transit.raptor.api.transit.CostCalculator;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransitDataProvider;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.transit.raptor.rangeraptor.RangeRaptorWorker;
import org.opentripplanner.transit.raptor.rangeraptor.context.SearchContext;
import org.opentripplanner.transit.raptor.rangeraptor.internalapi.HeuristicSearch;
import org.opentripplanner.transit.raptor.rangeraptor.internalapi.Heuristics;
import org.opentripplanner.transit.raptor.rangeraptor.internalapi.RoutingStrategy;
import org.opentripplanner.transit.raptor.rangeraptor.internalapi.Worker;
import org.opentripplanner.transit.raptor.rangeraptor.internalapi.WorkerState;
import org.opentripplanner.transit.raptor.rangeraptor.multicriteria.configure.McRangeRaptorConfig;
import org.opentripplanner.transit.raptor.rangeraptor.standard.configure.StdRangeRaptorConfig;
import org.opentripplanner.transit.raptor.rangeraptor.transit.RaptorSearchWindowCalculator;

public class RaptorConfig<T extends RaptorTripSchedule> {
    private final ExecutorService threadPool;
    private final RaptorTuningParameters tuningParameters;

    public RaptorConfig(RaptorTuningParameters tuningParameters) {
        this.tuningParameters = tuningParameters;
        this.threadPool = this.createNewThreadPool(tuningParameters.searchThreadPoolSize());
    }

    public static <T extends RaptorTripSchedule> RaptorConfig<T> defaultConfigForTest() {
        return new RaptorConfig<T>(new RaptorTuningParameters(){});
    }

    public SearchContext<T> context(RaptorTransitDataProvider<T> transit, RaptorRequest<T> request) {
        return new SearchContext<T>(request, this.tuningParameters, transit);
    }

    public Worker<T> createStdWorker(RaptorTransitDataProvider<T> transitData, RaptorRequest<T> request) {
        SearchContext<T> context = this.context(transitData, request);
        return new StdRangeRaptorConfig(context).createSearch((s, w) -> this.createWorker(context, (WorkerState<T>)s, (RoutingStrategy<T>)w));
    }

    public Worker<T> createMcWorker(RaptorTransitDataProvider<T> transitData, RaptorRequest<T> request, Heuristics heuristics) {
        SearchContext<T> context = this.context(transitData, request);
        return new McRangeRaptorConfig(context).createWorker(heuristics, (s, w) -> this.createWorker(context, (WorkerState<T>)s, (RoutingStrategy<T>)w));
    }

    public HeuristicSearch<T> createHeuristicSearch(RaptorTransitDataProvider<T> transitData, CostCalculator<T> costCalculator, RaptorRequest<T> request) {
        SearchContext<T> context = this.context(transitData, request);
        return new StdRangeRaptorConfig(context).createHeuristicSearch((s, w) -> this.createWorker(context, (WorkerState<T>)s, (RoutingStrategy<T>)w), costCalculator);
    }

    public boolean isMultiThreaded() {
        return this.threadPool != null;
    }

    public ExecutorService threadPool() {
        return this.threadPool;
    }

    public void shutdown() {
        if (this.threadPool != null) {
            this.threadPool.shutdown();
        }
    }

    public RaptorSearchWindowCalculator searchWindowCalculator() {
        return new RaptorSearchWindowCalculator(this.tuningParameters.dynamicSearchWindowCoefficients());
    }

    private Worker<T> createWorker(SearchContext<T> ctx, WorkerState<T> workerState, RoutingStrategy<T> routingStrategy) {
        return new RangeRaptorWorker<T>(workerState, routingStrategy, ctx.transit(), ctx.slackProvider(), ctx.accessPaths(), ctx.roundProvider(), ctx.calculator(), ctx.createLifeCyclePublisher(), ctx.performanceTimers(), ctx.enableConstrainedTransfers());
    }

    @Nullable
    private ExecutorService createNewThreadPool(int size) {
        return size > 0 ? Executors.newFixedThreadPool(size) : null;
    }
}

