/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.api.view;

import javax.annotation.Nullable;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.transit.raptor.api.transit.TransitArrival;
import org.opentripplanner.transit.raptor.api.view.AccessPathView;
import org.opentripplanner.transit.raptor.api.view.EgressPathView;
import org.opentripplanner.transit.raptor.api.view.TransferPathView;
import org.opentripplanner.transit.raptor.api.view.TransitPathView;
import org.opentripplanner.util.lang.OtpNumberFormat;
import org.opentripplanner.util.time.DurationUtils;
import org.opentripplanner.util.time.TimeUtils;

public interface ArrivalView<T extends RaptorTripSchedule> {
    public int stop();

    public int round();

    default public int numberOfTransfers() {
        return this.round() - 1;
    }

    default public boolean isFirstRound() {
        return this.round() == 0;
    }

    public int arrivalTime();

    default public int cost() {
        return 0;
    }

    public ArrivalView<T> previous();

    @Nullable
    default public TransitArrival<T> mostRecentTransitArrival() {
        return null;
    }

    default public boolean arrivedByAccess() {
        return false;
    }

    default public AccessPathView accessPath() {
        throw new UnsupportedOperationException();
    }

    default public boolean arrivedByTransit() {
        return false;
    }

    default public TransitPathView<T> transitPath() {
        throw new UnsupportedOperationException();
    }

    default public boolean arrivedByTransfer() {
        return false;
    }

    default public TransferPathView transferPath() {
        throw new UnsupportedOperationException();
    }

    default public boolean arrivedAtDestination() {
        return false;
    }

    default public EgressPathView egressPath() {
        throw new UnsupportedOperationException();
    }

    default public String asString() {
        if (this.arrivedByAccess()) {
            return String.format("Access { stop: %d, duration: %s, arrival-time: %s %s }", this.stop(), DurationUtils.durationToStr(this.accessPath().access().durationInSeconds()), TimeUtils.timeToStrCompact(this.arrivalTime()), OtpNumberFormat.formatCostCenti(this.cost()));
        }
        if (this.arrivedByTransit()) {
            return String.format("Transit { round: %d, stop: %d, pattern: %s, arrival-time: %s %s }", this.round(), this.stop(), this.transitPath().trip().pattern().debugInfo(), TimeUtils.timeToStrCompact(this.arrivalTime()), OtpNumberFormat.formatCostCenti(this.cost()));
        }
        if (this.arrivedByTransfer()) {
            return String.format("Walk { round: %d, stop: %d, arrival-time: %s %s }", this.round(), this.stop(), TimeUtils.timeToStrCompact(this.arrivalTime()), OtpNumberFormat.formatCostCenti(this.cost()));
        }
        if (this.arrivedAtDestination()) {
            return String.format("Egress { round: %d, from-stop: %d, duration: %s, arrival-time: %s %s }", this.round(), this.previous().stop(), DurationUtils.durationToStr(this.egressPath().egress().durationInSeconds()), TimeUtils.timeToStrCompact(this.arrivalTime()), OtpNumberFormat.formatCostCenti(this.cost()));
        }
        throw new IllegalStateException("Unknown type of stop-arrival: " + this.getClass());
    }
}

