/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.api.transit;

import java.util.ArrayList;
import java.util.List;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripPattern;

public interface RaptorTripSchedule {
    public int tripSortIndex();

    public int arrival(int var1);

    default public int arrival(int startStopPos, int stopIndex) {
        return this.arrival(this.pattern().findStopPositionAfter(startStopPos, stopIndex));
    }

    public int departure(int var1);

    default public int departure(int startStopPos, int stopIndex) {
        return this.departure(this.pattern().findStopPositionAfter(startStopPos, stopIndex));
    }

    public RaptorTripPattern pattern();

    default public int findArrivalStopPosition(int latestArrivalTime, int stop) {
        RaptorTripPattern p = this.pattern();
        int i = p.numberOfStopsInPattern() - 1;
        while (this.arrival(i) > latestArrivalTime) {
            if (--i != -1) continue;
            return -1;
        }
        return p.findStopPositionBefore(i, stop);
    }

    default public int findDepartureStopPosition(int earliestDepartureTime, int stop) {
        RaptorTripPattern p = this.pattern();
        int size = p.numberOfStopsInPattern();
        int i = 0;
        while (this.departure(i) < earliestDepartureTime) {
            if (++i != size) continue;
            return -1;
        }
        return p.findStopPositionAfter(i, stop);
    }

    default public List<Integer> findDepartureStopPositions(int earliestDepartureTime, int stop) {
        RaptorTripPattern p = this.pattern();
        int size = p.numberOfStopsInPattern();
        int i = 0;
        while (this.departure(i) < earliestDepartureTime) {
            if (++i != size) continue;
            return new ArrayList<Integer>();
        }
        ArrayList<Integer> stops = new ArrayList<Integer>();
        while (i < size) {
            if (stop == p.stopIndex(i)) {
                stops.add(i);
            }
            ++i;
        }
        return stops;
    }
}

