/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.api.transit;

import org.opentripplanner.util.time.DurationUtils;

public interface RaptorAccessEgress {
    public int stop();

    public int generalizedCost();

    public int durationInSeconds();

    default public int earliestDepartureTime(int requestedDepartureTime) {
        return requestedDepartureTime;
    }

    default public int latestArrivalTime(int requestedArrivalTime) {
        return requestedArrivalTime;
    }

    public boolean hasOpeningHours();

    default public int numberOfRides() {
        return 0;
    }

    default public boolean hasRides() {
        return this.numberOfRides() > 0;
    }

    default public boolean stopReachedOnBoard() {
        return false;
    }

    default public String asString() {
        String duration = DurationUtils.durationToStr(this.durationInSeconds());
        return this.hasRides() ? String.format("Flex%s %s %dx ~ %d", this.stopReachedOnBoard() ? "" : "+Walk", duration, this.numberOfRides(), this.stop()) : String.format("On-Street %s ~ %d", duration, this.stop());
    }
}

