/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.api.request;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.opentripplanner.transit.raptor.api.debug.RaptorTimers;
import org.opentripplanner.transit.raptor.api.request.DebugRequestBuilder;
import org.opentripplanner.transit.raptor.api.request.Optimization;
import org.opentripplanner.transit.raptor.api.request.RaptorProfile;
import org.opentripplanner.transit.raptor.api.request.RaptorRequest;
import org.opentripplanner.transit.raptor.api.request.SearchParamsBuilder;
import org.opentripplanner.transit.raptor.api.transit.RaptorSlackProvider;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.transit.raptor.api.transit.SearchDirection;

public class RaptorRequestBuilder<T extends RaptorTripSchedule> {
    private final SearchParamsBuilder<T> searchParams;
    private final Set<Optimization> optimizations = EnumSet.noneOf(Optimization.class);
    private final DebugRequestBuilder debug;
    private SearchDirection searchDirection;
    private RaptorSlackProvider slackProvider;
    private RaptorTimers performanceTimers;
    private RaptorProfile profile;
    private boolean freezeAliasFields = false;

    public RaptorRequestBuilder() {
        this(RaptorRequest.defaults());
    }

    RaptorRequestBuilder(RaptorRequest<T> defaults) {
        this.searchParams = new SearchParamsBuilder(this, defaults.searchParams());
        this.searchDirection = defaults.searchDirection();
        this.slackProvider = defaults.slackProvider();
        this.profile = defaults.profile();
        this.optimizations.addAll(defaults.optimizations());
        this.performanceTimers = defaults.performanceTimers();
        this.debug = new DebugRequestBuilder(defaults.debug());
    }

    public SearchParamsBuilder<T> searchParams() {
        return this.searchParams;
    }

    public RaptorProfile profile() {
        return this.profile;
    }

    public RaptorRequestBuilder<T> profile(RaptorProfile profile) {
        this.verifyAliasNotGeneratedYet();
        this.profile = profile;
        return this;
    }

    public SearchDirection searchDirection() {
        return this.searchDirection;
    }

    public RaptorRequestBuilder<T> searchDirection(SearchDirection searchDirection) {
        this.verifyAliasNotGeneratedYet();
        this.searchDirection = searchDirection;
        return this;
    }

    public RaptorSlackProvider slackProvider() {
        return this.slackProvider;
    }

    public void slackProvider(@Nonnull RaptorSlackProvider slackProvider) {
        this.slackProvider = slackProvider;
    }

    public Collection<Optimization> optimizations() {
        return this.optimizations;
    }

    public RaptorRequestBuilder<T> enableOptimization(Optimization optimization) {
        this.verifyAliasNotGeneratedYet();
        this.optimizations.add(optimization);
        return this;
    }

    public RaptorRequestBuilder<T> clearOptimizations() {
        this.optimizations.clear();
        return this;
    }

    public RaptorRequestBuilder<T> disableOptimization(Optimization optimization) {
        this.optimizations.remove((Object)optimization);
        return this;
    }

    public RaptorTimers performanceTimers() {
        return this.performanceTimers;
    }

    public RaptorRequestBuilder<T> performanceTimers(RaptorTimers performanceTimers) {
        this.performanceTimers = performanceTimers;
        return this;
    }

    public DebugRequestBuilder debug() {
        return this.debug;
    }

    public RaptorRequest<T> build() {
        return new RaptorRequest(this);
    }

    public String generateAlias() {
        this.freezeAliasFields = true;
        return RaptorRequestBuilder.generateRequestAlias(this.profile, this.searchDirection, this.optimizations);
    }

    static String generateRequestAlias(RaptorProfile profile, SearchDirection searchDirection, Collection<Optimization> optimizations) {
        Object name = profile.abbreviation();
        if (searchDirection.isInReverse()) {
            name = (String)name + "-Rev";
        }
        if (Optimization.PARALLEL.isOneOf(optimizations)) {
            name = (String)name + "-LL";
        }
        if (Optimization.PARETO_CHECK_AGAINST_DESTINATION.isOneOf(optimizations)) {
            name = (String)name + "-DP";
        }
        return name;
    }

    private void verifyAliasNotGeneratedYet() {
        if (this.freezeAliasFields) {
            throw new IllegalStateException("The alias is generated before one of the fileds it relay on is set.");
        }
    }
}

