/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.api.request;

import java.util.stream.Stream;

public enum RaptorProfile {
    MULTI_CRITERIA("Mc"),
    STANDARD("Standard"),
    BEST_TIME("StdBestTime"),
    MIN_TRAVEL_DURATION("MinTravelDuration"),
    MIN_TRAVEL_DURATION_BEST_TIME("MinTravelDurationBT");

    private final String abbreviation;

    private RaptorProfile(String abbreviation) {
        this.abbreviation = abbreviation;
    }

    public final String abbreviation() {
        return this.abbreviation;
    }

    public boolean is(RaptorProfile candidate) {
        return this == candidate;
    }

    public boolean isOneOf(RaptorProfile ... candidates) {
        return Stream.of(candidates).anyMatch(this::is);
    }

    public boolean useApproximateTripSearch() {
        return this.isOneOf(MIN_TRAVEL_DURATION, MIN_TRAVEL_DURATION_BEST_TIME);
    }
}

