/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.api.path;

import java.util.Objects;
import org.opentripplanner.transit.raptor.api.path.PathLeg;
import org.opentripplanner.transit.raptor.api.transit.BoardAndAlightTime;
import org.opentripplanner.transit.raptor.api.transit.RaptorConstrainedTransfer;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;

public final class TransitPathLeg<T extends RaptorTripSchedule>
implements PathLeg<T> {
    private final T trip;
    private final BoardAndAlightTime boardAndAlightTime;
    private final RaptorConstrainedTransfer constrainedTransferAfterLeg;
    private final int cost;
    private final PathLeg<T> next;
    private final int boardStop;
    private final int alightStop;

    public TransitPathLeg(T trip, BoardAndAlightTime boardAndAlightTime, RaptorConstrainedTransfer constrainedTransferAfterLeg, int cost, PathLeg<T> next) {
        this.trip = trip;
        this.boardAndAlightTime = boardAndAlightTime;
        this.constrainedTransferAfterLeg = constrainedTransferAfterLeg;
        this.cost = cost;
        this.next = next;
        this.boardStop = trip.pattern().stopIndex(boardAndAlightTime.boardStopPos());
        this.alightStop = trip.pattern().stopIndex(boardAndAlightTime.alightStopPos());
    }

    public T trip() {
        return this.trip;
    }

    public int getFromStopPosition() {
        return this.boardAndAlightTime.boardStopPos();
    }

    public int getToStopPosition() {
        return this.boardAndAlightTime.alightStopPos();
    }

    public RaptorConstrainedTransfer getConstrainedTransferAfterLeg() {
        return this.constrainedTransferAfterLeg;
    }

    @Override
    public int fromTime() {
        return this.boardAndAlightTime.boardTime();
    }

    @Override
    public int fromStop() {
        return this.boardStop;
    }

    @Override
    public int toTime() {
        return this.boardAndAlightTime.alightTime();
    }

    @Override
    public int toStop() {
        return this.alightStop;
    }

    @Override
    public int generalizedCost() {
        return this.cost;
    }

    @Override
    public boolean isTransitLeg() {
        return true;
    }

    @Override
    public PathLeg<T> nextLeg() {
        return this.next;
    }

    public boolean isStaySeatedOntoNextLeg() {
        return this.constrainedTransferAfterLeg != null && this.constrainedTransferAfterLeg.getTransferConstraint().isStaySeated();
    }

    public int hashCode() {
        return Objects.hash(this.boardAndAlightTime, this.trip, this.next);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransitPathLeg that = (TransitPathLeg)o;
        return this.boardAndAlightTime.equals(that.boardAndAlightTime) && this.trip.equals(that.trip) && this.next.equals(that.next);
    }

    public String toString() {
        return this.trip.pattern().debugInfo() + " " + this.asString(this.toStop());
    }
}

