/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.site;

import java.time.ZoneId;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.locationtech.jts.geom.Geometry;
import org.opentripplanner.transit.model.basic.Accessibility;
import org.opentripplanner.transit.model.basic.I18NString;
import org.opentripplanner.transit.model.basic.SubMode;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.basic.WgsCoordinate;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.framework.LogInfo;
import org.opentripplanner.transit.model.site.FareZone;
import org.opentripplanner.transit.model.site.Station;
import org.opentripplanner.transit.model.site.StationElement;
import org.opentripplanner.transit.model.site.StopTransferPriority;
import org.opentripplanner.util.lang.ObjectUtils;

public interface StopLocation
extends LogInfo {
    public static final AtomicInteger INDEX_COUNTER = new AtomicInteger(0);

    public FeedScopedId getId();

    public int getIndex();

    @Nullable
    public I18NString getName();

    @Nullable
    public I18NString getDescription();

    @Nullable
    public I18NString getUrl();

    @Nullable
    default public String getCode() {
        return null;
    }

    @Nullable
    default public String getPlatformCode() {
        return null;
    }

    @Nullable
    default public TransitMode getGtfsVehicleType() {
        return null;
    }

    @Nonnull
    default public SubMode getNetexVehicleSubmode() {
        return SubMode.UNKNOWN;
    }

    default public double getLat() {
        return this.getCoordinate().latitude();
    }

    default public double getLon() {
        return this.getCoordinate().longitude();
    }

    @Nullable
    default public Station getParentStation() {
        return null;
    }

    @Nonnull
    default public Collection<FareZone> getFareZones() {
        return List.of();
    }

    @Nonnull
    default public Accessibility getWheelchairAccessibility() {
        return Accessibility.NO_INFORMATION;
    }

    @Nullable
    default public String getFirstZoneAsString() {
        Iterator<FareZone> iterator = this.getFareZones().iterator();
        if (iterator.hasNext()) {
            FareZone t = iterator.next();
            return t.getId().getId();
        }
        return null;
    }

    @Nonnull
    public WgsCoordinate getCoordinate();

    @Nullable
    public Geometry getGeometry();

    @Nullable
    default public ZoneId getTimeZone() {
        return null;
    }

    public boolean isPartOfStation();

    @Nonnull
    default public StopTransferPriority getPriority() {
        return StopTransferPriority.ALLOWED;
    }

    public boolean isPartOfSameStationAs(StopLocation var1);

    @Override
    default public String logName() {
        return ObjectUtils.ifNotNull(this.getName(), Object::toString, null);
    }

    default public FeedScopedId getStationOrStopId() {
        StationElement stationElement;
        StopLocation stopLocation = this;
        if (stopLocation instanceof StationElement && (stationElement = (StationElement)((Object)stopLocation)).isPartOfStation()) {
            return stationElement.getParentStation().getId();
        }
        return this.getId();
    }

    default public boolean transfersNotAllowed() {
        return false;
    }

    public static int indexCounter() {
        return INDEX_COUNTER.get();
    }

    public static void initIndexCounter(int indexCounter) {
        INDEX_COUNTER.set(indexCounter);
    }
}

