/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.site;

import java.time.ZoneId;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.locationtech.jts.geom.Geometry;
import org.opentripplanner.transit.model.basic.I18NString;
import org.opentripplanner.transit.model.basic.SubMode;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.site.BoardingArea;
import org.opentripplanner.transit.model.site.FareZone;
import org.opentripplanner.transit.model.site.RegularStopBuilder;
import org.opentripplanner.transit.model.site.Station;
import org.opentripplanner.transit.model.site.StationElement;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.site.StopTransferPriority;
import org.opentripplanner.util.geometry.GeometryUtils;

public final class RegularStop
extends StationElement<RegularStop, RegularStopBuilder>
implements StopLocation {
    private final int index = INDEX_COUNTER.getAndIncrement();
    private final String platformCode;
    private final I18NString url;
    private final ZoneId timeZone;
    private final TransitMode gtfsVehicleType;
    private final SubMode netexVehicleSubmode;
    private final Set<BoardingArea> boardingAreas;
    private final Set<FareZone> fareZones;

    RegularStop(RegularStopBuilder builder) {
        super(builder);
        this.platformCode = builder.platformCode();
        this.url = builder.url();
        this.timeZone = builder.timeZone();
        this.gtfsVehicleType = builder.vehicleType();
        this.netexVehicleSubmode = SubMode.getOrBuildAndCacheForever(builder.netexVehicleSubmode());
        this.boardingAreas = RegularStop.setOfNullSafe(builder.boardingAreas());
        this.fareZones = RegularStop.setOfNullSafe(builder.fareZones());
        if (this.isPartOfStation()) {
            this.getParentStation().addChildStop(this);
        }
    }

    public static RegularStopBuilder of(FeedScopedId id) {
        return new RegularStopBuilder(id);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    @Nullable
    public String getPlatformCode() {
        return this.platformCode;
    }

    @Override
    @Nullable
    public I18NString getUrl() {
        return this.url;
    }

    @Override
    @Nullable
    public ZoneId getTimeZone() {
        if (this.timeZone != null) {
            return this.timeZone;
        }
        if (this.isPartOfStation()) {
            return this.getParentStation().getTimezone();
        }
        return null;
    }

    @Override
    @Nullable
    public TransitMode getGtfsVehicleType() {
        return this.gtfsVehicleType;
    }

    @Override
    @Nonnull
    public SubMode getNetexVehicleSubmode() {
        return this.netexVehicleSubmode;
    }

    @Override
    @Nonnull
    public Geometry getGeometry() {
        return GeometryUtils.getGeometryFactory().createPoint(this.getCoordinate().asJtsCoordinate());
    }

    @Override
    @Nonnull
    public StopTransferPriority getPriority() {
        return this.isPartOfStation() ? this.getParentStation().getPriority() : StopTransferPriority.ALLOWED;
    }

    @Override
    @Nonnull
    public Collection<FareZone> getFareZones() {
        return this.fareZones;
    }

    @Nonnull
    public Collection<BoardingArea> getBoardingAreas() {
        return this.boardingAreas;
    }

    @Nonnull
    public RegularStopBuilder copy() {
        return new RegularStopBuilder(this);
    }

    @Override
    public boolean sameAs(@Nonnull RegularStop other) {
        return super.sameAs(other) && Objects.equals(this.platformCode, other.platformCode) && Objects.equals(this.url, other.url) && Objects.equals(this.timeZone, other.timeZone) && Objects.equals((Object)this.gtfsVehicleType, (Object)other.gtfsVehicleType) && Objects.equals(this.netexVehicleSubmode, other.netexVehicleSubmode) && Objects.equals(this.boardingAreas, other.boardingAreas) && Objects.equals(this.fareZones, other.fareZones);
    }

    @Override
    public boolean transfersNotAllowed() {
        Station parentStation = this.getParentStation();
        return parentStation != null && parentStation.isTransfersNotAllowed();
    }
}

