/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.site;

import java.util.Objects;
import javax.annotation.Nonnull;
import org.opentripplanner.transit.model.basic.WgsCoordinate;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.site.BoardingAreaBuilder;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.StationElement;

public final class BoardingArea
extends StationElement<BoardingArea, BoardingAreaBuilder> {
    private final RegularStop parentStop;

    BoardingArea(BoardingAreaBuilder builder) {
        super(builder);
        this.parentStop = Objects.requireNonNull(builder.parentStop());
        Objects.requireNonNull(this.getCoordinate());
    }

    public static BoardingAreaBuilder of(FeedScopedId id) {
        return new BoardingAreaBuilder(id);
    }

    @Override
    @Nonnull
    public WgsCoordinate getCoordinate() {
        return this.isCoordinateSet() ? super.getCoordinate() : this.parentStop.getCoordinate();
    }

    @Nonnull
    public RegularStop getParentStop() {
        return this.parentStop;
    }

    @Nonnull
    public BoardingAreaBuilder copy() {
        return new BoardingAreaBuilder(this);
    }

    @Override
    public boolean sameAs(@Nonnull BoardingArea other) {
        return super.sameAs(other) && Objects.equals(this.parentStop, other.parentStop);
    }
}

