/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.organization;

import java.time.ZoneId;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opentripplanner.transit.model.framework.AbstractTransitEntity;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.framework.LogInfo;
import org.opentripplanner.transit.model.organization.AgencyBuilder;
import org.opentripplanner.util.lang.StringUtils;

public final class Agency
extends AbstractTransitEntity<Agency, AgencyBuilder>
implements LogInfo {
    private final String name;
    private final ZoneId timezone;
    private final String url;
    private final String lang;
    private final String phone;
    private final String fareUrl;
    private final String brandingUrl;

    Agency(AgencyBuilder builder) {
        super(builder.getId());
        this.name = StringUtils.assertHasValue(builder.getName(), "Missing mandatory name on Agency %s", builder.getId());
        this.timezone = ZoneId.of(StringUtils.assertHasValue(builder.getTimezone(), "Missing mandatory time zone on Agency %s", builder.getId()));
        this.url = builder.getUrl();
        this.lang = builder.getLang();
        this.phone = builder.getPhone();
        this.fareUrl = builder.getFareUrl();
        this.brandingUrl = builder.getBrandingUrl();
    }

    public static AgencyBuilder of(@Nonnull FeedScopedId id) {
        return new AgencyBuilder(id);
    }

    @Nonnull
    public String getName() {
        return this.logName();
    }

    @Nonnull
    public ZoneId getTimezone() {
        return this.timezone;
    }

    @Nullable
    public String getUrl() {
        return this.url;
    }

    @Nullable
    public String getLang() {
        return this.lang;
    }

    @Nullable
    public String getPhone() {
        return this.phone;
    }

    @Nullable
    public String getFareUrl() {
        return this.fareUrl;
    }

    @Nullable
    public String getBrandingUrl() {
        return this.brandingUrl;
    }

    @Nonnull
    public AgencyBuilder copy() {
        return new AgencyBuilder(this);
    }

    @Override
    @Nonnull
    public String logName() {
        return this.name;
    }

    @Override
    public boolean sameAs(@Nonnull Agency other) {
        return this.getId().equals(other.getId()) && Objects.equals(this.name, other.name) && Objects.equals(this.timezone, other.timezone) && Objects.equals(this.url, other.url) && Objects.equals(this.lang, other.lang) && Objects.equals(this.phone, other.phone) && Objects.equals(this.fareUrl, other.fareUrl) && Objects.equals(this.brandingUrl, other.brandingUrl);
    }
}

