/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.network;

import java.io.Serializable;
import java.util.BitSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.opentripplanner.routing.algorithm.raptoradapter.api.DefaultTripPattern;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.network.TripPatternBuilder;
import org.opentripplanner.transit.model.site.StopLocation;

public class RoutingTripPattern
implements DefaultTripPattern,
Serializable {
    private static final AtomicInteger INDEX_COUNTER = new AtomicInteger(0);
    private final int index;
    private final TripPattern pattern;
    private final int[] stopIndexes;
    private final BitSet boardingPossible;
    private final BitSet alightingPossible;
    private final BitSet wheelchairAccessible;
    private final int slackIndex;
    private final int transitReluctanceFactorIndex;

    RoutingTripPattern(TripPattern pattern, TripPatternBuilder builder) {
        this.pattern = pattern;
        this.stopIndexes = pattern.getStops().stream().mapToInt(StopLocation::getIndex).toArray();
        this.index = INDEX_COUNTER.getAndIncrement();
        int nStops = this.stopIndexes.length;
        this.boardingPossible = new BitSet(nStops);
        this.alightingPossible = new BitSet(nStops);
        this.wheelchairAccessible = new BitSet(nStops);
        for (int s = 0; s < nStops; ++s) {
            this.boardingPossible.set(s, pattern.canBoard(s));
            this.alightingPossible.set(s, pattern.canAlight(s));
            this.wheelchairAccessible.set(s, pattern.wheelchairAccessible(s));
        }
        this.slackIndex = builder.slackIndex();
        this.transitReluctanceFactorIndex = builder.transitReluctanceFactorIndex();
    }

    @Override
    public int patternIndex() {
        return this.index;
    }

    public final TripPattern getPattern() {
        return this.pattern;
    }

    public BitSet getBoardingPossible() {
        return this.boardingPossible;
    }

    public BitSet getAlightingPossible() {
        return this.alightingPossible;
    }

    public BitSet getWheelchairAccessible() {
        return this.wheelchairAccessible;
    }

    @Override
    public int numberOfStopsInPattern() {
        return this.stopIndexes.length;
    }

    @Override
    public int stopIndex(int stopPositionInPattern) {
        return this.stopIndexes[stopPositionInPattern];
    }

    @Override
    public boolean boardingPossibleAt(int stopPositionInPattern) {
        return this.boardingPossible.get(stopPositionInPattern);
    }

    @Override
    public boolean alightingPossibleAt(int stopPositionInPattern) {
        return this.alightingPossible.get(stopPositionInPattern);
    }

    @Override
    public int slackIndex() {
        return this.slackIndex;
    }

    public int transitReluctanceFactorIndex() {
        return this.transitReluctanceFactorIndex;
    }

    @Override
    public Route route() {
        return this.pattern.getRoute();
    }

    @Override
    public String debugInfo() {
        return this.pattern.logName() + " @" + this.index;
    }

    public int hashCode() {
        return this.index;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RoutingTripPattern)) {
            return false;
        }
        RoutingTripPattern that = (RoutingTripPattern)o;
        return this.index == that.patternIndex();
    }

    public String toString() {
        return "RoutingTripPattern{" + this.debugInfo() + "}";
    }

    public static int indexCounter() {
        return INDEX_COUNTER.get();
    }

    public static void initIndexCounter(int indexCounter) {
        INDEX_COUNTER.set(indexCounter);
    }
}

