/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.server;

import com.google.common.hash.Hashing;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.codec.binary.Hex;

public class EtagRequestFilter
implements ContainerResponseFilter {
    public static final String DIRECTIVE_NO_STORE = "no-store";
    public static final String HEADER_ETAG = "ETag";
    public static final String HEADER_IF_NONE_MATCH = "If-None-Match";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_CACHE_CONTROL = "Cache-Control";

    public void filter(ContainerRequestContext request, ContainerResponseContext response) throws IOException {
        byte[] bytes;
        Object object;
        if (EtagRequestFilter.isEligibleForEtag(request, response) && EtagRequestFilter.hasAllowedContentType(response) && (object = response.getEntity()) instanceof byte[] && (bytes = (byte[])object).length > 0) {
            String clientEtag = request.getHeaderString(HEADER_IF_NONE_MATCH);
            String etag = EtagRequestFilter.generateETagHeaderValue(bytes);
            MultivaluedMap headers = response.getHeaders();
            headers.add((Object)HEADER_ETAG, (Object)etag);
            if (clientEtag != null && clientEtag.equals(etag)) {
                response.setEntity(null);
                response.setEntityStream((OutputStream)new ByteArrayOutputStream());
                response.setStatus(304);
            }
        }
    }

    private static boolean isEligibleForEtag(ContainerRequestContext request, ContainerResponseContext response) {
        int statusCode = response.getStatus();
        if (statusCode >= 200 && statusCode < 300 && "GET".matches(request.getMethod())) {
            String cacheControl = response.getHeaderString(HEADER_CACHE_CONTROL);
            return cacheControl == null || !cacheControl.contains(DIRECTIVE_NO_STORE);
        }
        return false;
    }

    private static String generateETagHeaderValue(byte[] input) {
        StringBuilder builder = new StringBuilder(10);
        builder.append('\"');
        byte[] hash = Hashing.murmur3_32_fixed().hashBytes(input).asBytes();
        char[] hex = Hex.encodeHex((byte[])hash);
        builder.append(hex);
        builder.append('\"');
        return builder.toString();
    }

    private static boolean hasAllowedContentType(ContainerResponseContext response) {
        return "application/x-protobuf".equals(response.getStringHeaders().getFirst((Object)HEADER_CONTENT_TYPE));
    }
}

