/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.server;

import io.micrometer.core.instrument.MeterRegistry;
import java.util.Locale;
import javax.annotation.Nullable;
import org.opentripplanner.inspector.TileRendererManager;
import org.opentripplanner.routing.RoutingService;
import org.opentripplanner.routing.algorithm.astar.TraverseVisitor;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripSchedule;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.preference.RoutingPreferences;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.standalone.api.OtpServerRequestContext;
import org.opentripplanner.standalone.config.RouterConfig;
import org.opentripplanner.standalone.configure.RequestLoggerFactory;
import org.opentripplanner.transit.raptor.configure.RaptorConfig;
import org.opentripplanner.transit.service.TransitService;
import org.slf4j.Logger;

public class DefaultServerRequestContext
implements OtpServerRequestContext {
    private RouteRequest routeRequest = null;
    private final Graph graph;
    private final TransitService transitService;
    private final RouterConfig routerConfig;
    private final MeterRegistry meterRegistry;
    private final RaptorConfig<TripSchedule> raptorConfig;
    public final Logger requestLogger;
    private final TileRendererManager tileRendererManager;
    public final TraverseVisitor traverseVisitor;

    private DefaultServerRequestContext(Graph graph, TransitService transitService, RouterConfig routerConfig, MeterRegistry meterRegistry, RaptorConfig<TripSchedule> raptorConfig, Logger requestLogger, TileRendererManager tileRendererManager, TraverseVisitor traverseVisitor) {
        this.graph = graph;
        this.transitService = transitService;
        this.routerConfig = routerConfig;
        this.meterRegistry = meterRegistry;
        this.raptorConfig = raptorConfig;
        this.requestLogger = requestLogger;
        this.tileRendererManager = tileRendererManager;
        this.traverseVisitor = traverseVisitor;
    }

    public static DefaultServerRequestContext create(RouterConfig routerConfig, RaptorConfig<TripSchedule> raptorConfig, Graph graph, TransitService transitService, MeterRegistry meterRegistry, @Nullable TraverseVisitor traverseVisitor) {
        RoutingPreferences defaultRoutingPreferences = routerConfig.routingRequestDefaults().preferences();
        return new DefaultServerRequestContext(graph, transitService, routerConfig, meterRegistry, raptorConfig, RequestLoggerFactory.createLogger(routerConfig.requestLogFile()), new TileRendererManager(graph, defaultRoutingPreferences), traverseVisitor);
    }

    @Override
    public RouteRequest defaultRouteRequest() {
        if (this.routeRequest == null) {
            this.routeRequest = this.routerConfig.routingRequestDefaults().copyWithDateTimeNow();
        }
        return this.routeRequest;
    }

    @Override
    public Locale defaultLocale() {
        return this.routerConfig().routingRequestDefaults().locale();
    }

    @Override
    public RouterConfig routerConfig() {
        return this.routerConfig;
    }

    @Override
    public RaptorConfig<TripSchedule> raptorConfig() {
        return this.raptorConfig;
    }

    @Override
    public Graph graph() {
        return this.graph;
    }

    @Override
    public TransitService transitService() {
        return this.transitService;
    }

    @Override
    public RoutingService routingService() {
        return new RoutingService(this);
    }

    @Override
    public MeterRegistry meterRegistry() {
        return this.meterRegistry;
    }

    @Override
    public Logger requestLogger() {
        return this.requestLogger;
    }

    @Override
    public TileRendererManager tileRendererManager() {
        return this.tileRendererManager;
    }

    @Override
    public TraverseVisitor traverseVisitor() {
        return this.traverseVisitor;
    }
}

