/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.configure;

import org.opentripplanner.datastore.api.DataSource;
import org.opentripplanner.graph_builder.GraphBuilderDataSources;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.SerializedGraphObject;
import org.opentripplanner.standalone.config.CommandLineParameters;
import org.opentripplanner.standalone.config.ConfigModel;
import org.opentripplanner.standalone.configure.ConstructApplication;
import org.opentripplanner.standalone.configure.DaggerLoadApplicationFactory;
import org.opentripplanner.standalone.configure.LoadApplicationFactory;
import org.opentripplanner.transit.service.TransitModel;

public class LoadApplication {
    private final CommandLineParameters cli;
    private final LoadApplicationFactory factory;
    private boolean dataStoreLoaded = false;

    public LoadApplication(CommandLineParameters commandLineParameters) {
        this.cli = commandLineParameters;
        this.factory = DaggerLoadApplicationFactory.builder().commandLineParameters(this.cli).build();
    }

    public void validateConfigAndDataSources() {
        this.factory.graphBuilderDataSources();
        this.dataStoreLoaded = true;
    }

    public DataSource getInputGraphDataStore() {
        return this.cli.doLoadGraph() ? this.factory.datastore().getGraph() : this.factory.datastore().getStreetGraph();
    }

    public ConstructApplication appConstruction(SerializedGraphObject obj) {
        return this.createAppConstruction(obj.graph, obj.transitModel);
    }

    public ConstructApplication appConstruction() {
        return this.createAppConstruction(this.factory.emptyGraph(), this.factory.emptyTransitModel());
    }

    public GraphBuilderDataSources graphBuilderDataSources() {
        if (!this.dataStoreLoaded) {
            throw new IllegalStateException("Validate graphBuilderDataSources before using it");
        }
        return this.factory.graphBuilderDataSources();
    }

    public ConfigModel config() {
        return this.factory.configModel();
    }

    private ConstructApplication createAppConstruction(Graph graph, TransitModel transitModel) {
        return new ConstructApplication(this.cli, graph, transitModel, this.config(), this.graphBuilderDataSources());
    }
}

