/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.configure;

import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import java.io.File;
import javax.inject.Provider;
import org.opentripplanner.datastore.OtpDataStore;
import org.opentripplanner.datastore.api.OtpDataStoreConfig;
import org.opentripplanner.datastore.base.DataSourceRepository;
import org.opentripplanner.datastore.configure.DataStoreModule_ProvideDataStoreFactory;
import org.opentripplanner.ext.datastore.gs.GsDataSourceModule;
import org.opentripplanner.ext.datastore.gs.GsDataSourceModule_ProvideGoogleStorageDataSourceRepositoryFactory;
import org.opentripplanner.graph_builder.GraphBuilderDataSources;
import org.opentripplanner.graph_builder.GraphBuilderDataSources_Factory;
import org.opentripplanner.model.calendar.ServiceDateInterval;
import org.opentripplanner.model.calendar.openinghours.OpeningHoursCalendarService;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.standalone.config.BuildConfig;
import org.opentripplanner.standalone.config.CommandLineParameters;
import org.opentripplanner.standalone.config.ConfigModel;
import org.opentripplanner.standalone.config.OtpConfigLoader;
import org.opentripplanner.standalone.config.configure.ConfigModule_ProvideBuildConfigFactory;
import org.opentripplanner.standalone.config.configure.LoadConfigModule_BaseDirectoryFactory;
import org.opentripplanner.standalone.config.configure.LoadConfigModule_ProvidesConfigLoaderFactory;
import org.opentripplanner.standalone.config.configure.LoadConfigModule_ProvidesDataStoreConfigFactory;
import org.opentripplanner.standalone.config.configure.LoadConfigModule_ProvidesModelFactory;
import org.opentripplanner.standalone.config.configure.LoadConfigModule_ProvidesTransitServicePeriodFactory;
import org.opentripplanner.standalone.configure.LoadApplicationFactory;
import org.opentripplanner.transit.model.framework.Deduplicator;
import org.opentripplanner.transit.service.StopModel;
import org.opentripplanner.transit.service.TransitModel;

@DaggerGenerated
public final class DaggerLoadApplicationFactory {
    private DaggerLoadApplicationFactory() {
    }

    public static LoadApplicationFactory.Builder builder() {
        return new Builder();
    }

    private static final class Builder
    implements LoadApplicationFactory.Builder {
        private CommandLineParameters commandLineParameters;

        private Builder() {
        }

        @Override
        public Builder commandLineParameters(CommandLineParameters cli) {
            this.commandLineParameters = (CommandLineParameters)Preconditions.checkNotNull((Object)cli);
            return this;
        }

        @Override
        public LoadApplicationFactory build() {
            Preconditions.checkBuilderRequirement((Object)this.commandLineParameters, CommandLineParameters.class);
            return new LoadApplicationFactoryImpl(new GsDataSourceModule(), this.commandLineParameters);
        }
    }

    private static final class LoadApplicationFactoryImpl
    implements LoadApplicationFactory {
        private final LoadApplicationFactoryImpl loadApplicationFactoryImpl = this;
        private Provider<CommandLineParameters> commandLineParametersProvider;
        private Provider<File> baseDirectoryProvider;
        private Provider<OtpConfigLoader> providesConfigLoaderProvider;
        private Provider<ConfigModel> providesModelProvider;
        private Provider<BuildConfig> provideBuildConfigProvider;
        private Provider<OtpDataStoreConfig> providesDataStoreConfigProvider;
        private Provider<DataSourceRepository> provideGoogleStorageDataSourceRepositoryProvider;
        private Provider<OtpDataStore> provideDataStoreProvider;
        private Provider<GraphBuilderDataSources> graphBuilderDataSourcesProvider;

        private LoadApplicationFactoryImpl(GsDataSourceModule gsDataSourceModuleParam, CommandLineParameters commandLineParametersParam) {
            this.initialize(gsDataSourceModuleParam, commandLineParametersParam);
        }

        private BuildConfig buildConfig() {
            return ConfigModule_ProvideBuildConfigFactory.provideBuildConfig((ConfigModel)this.providesModelProvider.get());
        }

        private ServiceDateInterval transitServicePeriodServiceDateInterval() {
            return LoadConfigModule_ProvidesTransitServicePeriodFactory.providesTransitServicePeriod(this.buildConfig());
        }

        private OpeningHoursCalendarService openingHoursCalendarService() {
            return new OpeningHoursCalendarService(new Deduplicator(), this.transitServicePeriodServiceDateInterval());
        }

        private void initialize(GsDataSourceModule gsDataSourceModuleParam, CommandLineParameters commandLineParametersParam) {
            this.commandLineParametersProvider = InstanceFactory.create((Object)commandLineParametersParam);
            this.baseDirectoryProvider = LoadConfigModule_BaseDirectoryFactory.create(this.commandLineParametersProvider);
            this.providesConfigLoaderProvider = LoadConfigModule_ProvidesConfigLoaderFactory.create(this.baseDirectoryProvider);
            this.providesModelProvider = DoubleCheck.provider((Provider)LoadConfigModule_ProvidesModelFactory.create(this.providesConfigLoaderProvider));
            this.provideBuildConfigProvider = ConfigModule_ProvideBuildConfigFactory.create(this.providesModelProvider);
            this.providesDataStoreConfigProvider = LoadConfigModule_ProvidesDataStoreConfigFactory.create(this.provideBuildConfigProvider);
            this.provideGoogleStorageDataSourceRepositoryProvider = DoubleCheck.provider((Provider)GsDataSourceModule_ProvideGoogleStorageDataSourceRepositoryFactory.create(gsDataSourceModuleParam, this.providesDataStoreConfigProvider));
            this.provideDataStoreProvider = DoubleCheck.provider((Provider)DataStoreModule_ProvideDataStoreFactory.create(this.baseDirectoryProvider, this.providesDataStoreConfigProvider, this.provideGoogleStorageDataSourceRepositoryProvider));
            this.graphBuilderDataSourcesProvider = DoubleCheck.provider((Provider)GraphBuilderDataSources_Factory.create(this.commandLineParametersProvider, this.provideBuildConfigProvider, this.provideDataStoreProvider, this.baseDirectoryProvider));
        }

        @Override
        public OtpDataStore datastore() {
            return (OtpDataStore)this.provideDataStoreProvider.get();
        }

        @Override
        public ConfigModel configModel() {
            return (ConfigModel)this.providesModelProvider.get();
        }

        @Override
        public Graph emptyGraph() {
            return new Graph(new Deduplicator(), this.openingHoursCalendarService());
        }

        @Override
        public TransitModel emptyTransitModel() {
            return new TransitModel(new StopModel(), new Deduplicator());
        }

        @Override
        public GraphBuilderDataSources graphBuilderDataSources() {
            return (GraphBuilderDataSources)this.graphBuilderDataSourcesProvider.get();
        }
    }
}

