/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.configure;

import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import javax.inject.Provider;
import org.opentripplanner.routing.algorithm.astar.TraverseVisitor;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripSchedule;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.standalone.api.OtpServerRequestContext;
import org.opentripplanner.standalone.config.ConfigModel;
import org.opentripplanner.standalone.config.RouterConfig;
import org.opentripplanner.standalone.config.configure.ConfigModule_ProvideRouterConfigFactory;
import org.opentripplanner.standalone.config.configure.ConfigModule_ProvidesRaptorConfigFactory;
import org.opentripplanner.standalone.configure.ConstructApplicationFactory;
import org.opentripplanner.standalone.configure.ConstructApplicationModule;
import org.opentripplanner.standalone.configure.ConstructApplicationModule_ProvidesServerContextFactory;
import org.opentripplanner.standalone.server.MetricsLogging;
import org.opentripplanner.transit.raptor.configure.RaptorConfig;
import org.opentripplanner.transit.service.DefaultTransitService;
import org.opentripplanner.transit.service.TransitModel;
import org.opentripplanner.transit.service.TransitService;
import org.opentripplanner.visualizer.GraphVisualizer;

@DaggerGenerated
public final class DaggerConstructApplicationFactory {
    private DaggerConstructApplicationFactory() {
    }

    public static ConstructApplicationFactory.Builder builder() {
        return new Builder();
    }

    private static final class Builder
    implements ConstructApplicationFactory.Builder {
        private ConfigModel configModel;
        private Graph graph;
        private TransitModel transitModel;
        private GraphVisualizer graphVisualizer;

        private Builder() {
        }

        @Override
        public Builder configModel(ConfigModel config) {
            this.configModel = (ConfigModel)Preconditions.checkNotNull((Object)config);
            return this;
        }

        @Override
        public Builder graph(Graph graph) {
            this.graph = (Graph)Preconditions.checkNotNull((Object)graph);
            return this;
        }

        @Override
        public Builder transitModel(TransitModel transitModel) {
            this.transitModel = (TransitModel)Preconditions.checkNotNull((Object)transitModel);
            return this;
        }

        @Override
        public Builder graphVisualizer(GraphVisualizer graphVisualizer) {
            this.graphVisualizer = graphVisualizer;
            return this;
        }

        @Override
        public ConstructApplicationFactory build() {
            Preconditions.checkBuilderRequirement((Object)this.configModel, ConfigModel.class);
            Preconditions.checkBuilderRequirement((Object)this.graph, Graph.class);
            Preconditions.checkBuilderRequirement((Object)this.transitModel, TransitModel.class);
            return new ConstructApplicationFactoryImpl(new ConstructApplicationModule(), this.configModel, this.graph, this.transitModel, this.graphVisualizer);
        }
    }

    private static final class ConstructApplicationFactoryImpl
    implements ConstructApplicationFactory {
        private final ConfigModel configModel;
        private final Graph graph;
        private final TransitModel transitModel;
        private final GraphVisualizer graphVisualizer;
        private final ConstructApplicationModule constructApplicationModule;
        private final ConstructApplicationFactoryImpl constructApplicationFactoryImpl = this;
        private Provider<ConfigModel> configModelProvider;
        private Provider<RaptorConfig<TripSchedule>> providesRaptorConfigProvider;

        private ConstructApplicationFactoryImpl(ConstructApplicationModule constructApplicationModuleParam, ConfigModel configModelParam, Graph graphParam, TransitModel transitModelParam, GraphVisualizer graphVisualizerParam) {
            this.configModel = configModelParam;
            this.graph = graphParam;
            this.transitModel = transitModelParam;
            this.graphVisualizer = graphVisualizerParam;
            this.constructApplicationModule = constructApplicationModuleParam;
            this.initialize(constructApplicationModuleParam, configModelParam, graphParam, transitModelParam, graphVisualizerParam);
        }

        private DefaultTransitService defaultTransitService() {
            return new DefaultTransitService(this.transitModel);
        }

        private RouterConfig routerConfig() {
            return ConfigModule_ProvideRouterConfigFactory.provideRouterConfig(this.configModel);
        }

        private TraverseVisitor traverseVisitor() {
            return this.constructApplicationModule.traverseVisitor(this.graphVisualizer);
        }

        private void initialize(ConstructApplicationModule constructApplicationModuleParam, ConfigModel configModelParam, Graph graphParam, TransitModel transitModelParam, GraphVisualizer graphVisualizerParam) {
            this.configModelProvider = InstanceFactory.create((Object)configModelParam);
            this.providesRaptorConfigProvider = DoubleCheck.provider((Provider)ConfigModule_ProvidesRaptorConfigFactory.create(this.configModelProvider));
        }

        @Override
        public ConfigModel config() {
            return this.configModel;
        }

        @Override
        public RaptorConfig<TripSchedule> raptorConfig() {
            return (RaptorConfig)this.providesRaptorConfigProvider.get();
        }

        @Override
        public Graph graph() {
            return this.graph;
        }

        @Override
        public TransitModel transitModel() {
            return this.transitModel;
        }

        @Override
        public GraphVisualizer graphVisualizer() {
            return this.graphVisualizer;
        }

        @Override
        public TransitService transitService() {
            return this.defaultTransitService();
        }

        @Override
        public OtpServerRequestContext createServerContext() {
            return ConstructApplicationModule_ProvidesServerContextFactory.providesServerContext(this.constructApplicationModule, this.routerConfig(), (RaptorConfig)this.providesRaptorConfigProvider.get(), this.graph, this.defaultTransitService(), this.traverseVisitor());
        }

        @Override
        public MetricsLogging metricsLogging() {
            return new MetricsLogging(this.transitModel, (RaptorConfig)this.providesRaptorConfigProvider.get());
        }
    }
}

