/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config.routerconfig.updaters.azure;

import java.time.LocalDate;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import org.opentripplanner.ext.siri.updater.azure.SiriAzureUpdaterParameters;
import org.opentripplanner.standalone.config.framework.json.NodeAdapter;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;

public abstract class SiriAzureUpdaterConfig {
    public static void populateConfig(SiriAzureUpdaterParameters parameters, String configRef, NodeAdapter c) {
        parameters.setConfigRef(configRef);
        parameters.setServiceBusUrl(c.of("servicebus-url").since(OtpVersion.NA).summary("TODO").asString(null));
        parameters.setTopicName(c.of("topic").since(OtpVersion.NA).summary("TODO").asString(null));
        parameters.setFeedId(c.of("feedId").since(OtpVersion.NA).summary("TODO").asString(null));
        parameters.setFuzzyTripMatching(c.of("fuzzyTripMatching").since(OtpVersion.NA).summary("TODO").asBoolean(false));
        if (c.exist("history")) {
            NodeAdapter history = c.of("history").since(OtpVersion.NA).summary("TODO").description("TODO").asObject();
            parameters.setDataInitializationUrl(history.of("url").since(OtpVersion.NA).summary("TODO").asString(null));
            parameters.setTimeout(history.of("timeout").since(OtpVersion.NA).summary("TODO").asInt(300000));
        }
    }

    protected static LocalDate asDateOrRelativePeriod(String text, int customMidnight) {
        try {
            if (text == null || text.isBlank()) {
                return null;
            }
            if (text.startsWith("-") || text.startsWith("P")) {
                return SiriAzureUpdaterConfig.getDateBasedOnCustomMidnight(ZonedDateTime.now(ZoneId.of("CET")).plus(Period.parse(text)), customMidnight);
            }
            return LocalDate.parse(text);
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException(text + "' is not a Period or LocalDate. Details: " + e.getLocalizedMessage());
        }
    }

    public static LocalDate getDateBasedOnCustomMidnight(ZonedDateTime time, int customMidnight) {
        if (time.isBefore(time.withHour(customMidnight).withMinute(0).withSecond(0).withNano(0))) {
            return time.minusDays(1L).toLocalDate();
        }
        return time.toLocalDate();
    }
}

