/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config.routerconfig.updaters;

import org.opentripplanner.standalone.config.framework.json.NodeAdapter;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;
import org.opentripplanner.updater.trip.BackwardsDelayPropagationType;
import org.opentripplanner.updater.trip.PollingTripUpdaterParameters;
import org.opentripplanner.util.OtpAppException;

public class PollingStoptimeUpdaterConfig {
    public static PollingTripUpdaterParameters create(String configRef, NodeAdapter c) {
        String file = null;
        String url = null;
        if (c.exist("file")) {
            file = c.of("file").since(OtpVersion.NA).summary("The path of the GTFS-RT file.").asString();
        } else if (c.exist("url")) {
            url = c.of("url").since(OtpVersion.NA).summary("The URL of the GTFS-RT resource.").asString();
        } else {
            throw new OtpAppException("Need either 'url' or 'file' properties to configure " + configRef + " but received: " + c.asText());
        }
        return new PollingTripUpdaterParameters(configRef, c.of("frequencySec").since(OtpVersion.NA).summary("How often the data should be downloaded in seconds.").asInt(60), c.of("maxSnapshotFrequencyMs").since(OtpVersion.NA).summary("TODO").asInt(-1), c.of("purgeExpiredData").since(OtpVersion.NA).summary("Should expired data removed from the snapshot.").asBoolean(false), c.of("fuzzyTripMatching").since(OtpVersion.NA).summary("If the trips should be matched fuzzily.").asBoolean(false), c.of("backwardsDelayPropagationType").since(OtpVersion.V2_2).summary("How backwards propagation should be handled.").description("  REQUIRED_NO_DATA:\n  Default value. Only propagates delays backwards when it is required to ensure that the times\n  are increasing, and it sets the NO_DATA flag on the stops so these automatically updated times\n  are not exposed through APIs.\n\n  REQUIRED:\n  Only propagates delays backwards when it is required to ensure that the times are increasing.\n  The updated times are exposed through APIs.\n\n  ALWAYS\n  Propagates delays backwards on stops with no estimates regardless if it's required or not.\n  The updated times are exposed through APIs.\n").asEnum(BackwardsDelayPropagationType.REQUIRED_NO_DATA), c.of("feedId").since(OtpVersion.NA).summary("Which feed the updates apply to.").asString(null), url, file);
    }
}

