/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config.routerconfig;

import java.util.Collection;
import java.util.List;
import org.opentripplanner.ext.vectortiles.VectorTilesResource;
import org.opentripplanner.standalone.config.framework.json.NodeAdapter;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;

public class VectorTileConfig
implements VectorTilesResource.LayersParameters {
    List<VectorTilesResource.LayerParameters> layers;

    public VectorTileConfig(Collection<? extends VectorTilesResource.LayerParameters> layers) {
        this.layers = List.copyOf(layers);
    }

    @Override
    public List<VectorTilesResource.LayerParameters> layers() {
        return this.layers;
    }

    public static VectorTileConfig mapVectorTilesParameters(NodeAdapter root, String vectorTileLayers) {
        return new VectorTileConfig(root.of(vectorTileLayers).since(OtpVersion.V2_0).summary("Configuration of the individual layers for the Mapbox vector tiles.").asObjects(VectorTileConfig::mapLayer));
    }

    public static Layer mapLayer(NodeAdapter node) {
        return new Layer(node.of("name").since(OtpVersion.V2_0).summary("Used in the url to fetch tiles, and as the layer name in the vector tiles.").asString(), (VectorTilesResource.LayerType)((Object)node.of("type").since(OtpVersion.V2_0).summary("Type of the layer.").asEnum(VectorTilesResource.LayerType.class)), node.of("mapper").since(OtpVersion.V2_0).summary("Describes the mapper converting from the OTP model entities to the vector tile properties.").description("Currently `Digitransit` is supported for all layer types.").asString(), node.of("maxZoom").since(OtpVersion.V2_0).summary("Maximum zoom levels the layer is active for.").asInt(20), node.of("minZoom").since(OtpVersion.V2_0).summary("Minimum zoom levels the layer is active for.").asInt(9), node.of("cacheMaxSeconds").since(OtpVersion.V2_0).summary("Sets the cache header in the response.").description("The lowest value of the layers included is selected.").asInt(-1), node.of("expansionFactor").since(OtpVersion.V2_0).summary("How far outside its boundaries should the tile contain information.").description("The value is a fraction of the tile size. If you are having problem with icons and shapes being clipped at tile edges, then increase this number.").asDouble(0.25));
    }

    record Layer(String name, VectorTilesResource.LayerType type, String mapper, int maxZoom, int minZoom, int cacheMaxSeconds, double expansionFactor) implements VectorTilesResource.LayerParameters
    {
    }
}

