/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config.buildconfig;

import java.util.List;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.standalone.config.framework.json.NodeAdapter;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;
import org.opentripplanner.standalone.config.routerequest.RouteRequestConfig;

public class TransferRequestConfig {
    public static List<RouteRequest> map(NodeAdapter root, String transferRequestsName) {
        return root.of(transferRequestsName).since(OtpVersion.V2_1).summary("Routing requests to use for pre-calculating stop-to-stop transfers.").description("It will use the street network if OSM data has already been loaded into the graph. Otherwise it\nwill use straight-line distance between stops.\n\nIf not set, the default behavior is to generate stop-to-stop transfers using the default request\nwith street mode set to WALK. Use this to change the default or specify more than one way to\ntransfer.\n\n**Example**\n\n```JSON\n// build-config.json\n{\n  \"transferRequests\": [\n    { \"modes\": \"WALK\" },\n    { \"modes\": \"WALK\", \"wheelchairAccessibility\": { \"enabled\": true }}\n  ]\n}\n```\n").asObjects(List.of(new RouteRequest()), RouteRequestConfig::mapRouteRequest);
    }
}

