/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config.buildconfig;

import java.net.URI;
import java.time.ZoneId;
import org.opentripplanner.graph_builder.module.osm.parameters.OsmDefaultParameters;
import org.opentripplanner.graph_builder.module.osm.parameters.OsmExtractParameters;
import org.opentripplanner.graph_builder.module.osm.parameters.OsmExtractParametersBuilder;
import org.opentripplanner.graph_builder.module.osm.parameters.OsmExtractParametersList;
import org.opentripplanner.graph_builder.module.osm.tagmapping.OsmTagMapper;
import org.opentripplanner.standalone.config.framework.json.NodeAdapter;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;

public class OsmConfig {
    public static OsmDefaultParameters mapOsmDefaults(NodeAdapter root, String parameterName) {
        NodeAdapter osmDefaults = root.of(parameterName).since(OtpVersion.V2_2).summary("Default properties for OpenStreetMap feeds.").asObject();
        return new OsmDefaultParameters(OsmConfig.mapTagMapping(osmDefaults), OsmConfig.mapTimeZone(osmDefaults));
    }

    public static OsmExtractParametersList mapOsmConfig(NodeAdapter root, String parameterName) {
        return new OsmExtractParametersList(root.of(parameterName).since(OtpVersion.V2_2).summary("Configure properties for a given OpenStreetMap feed.").description("The osm section of build-config.json allows you to override the default behavior of scanning\nfor OpenStreetMap files in the base directory. You can specify data located outside the\nlocal filesystem (including cloud storage services) or at various different locations around\nthe local filesystem.\n").asObjects(OsmConfig::mapOsmExtractConfig));
    }

    private static OsmExtractParameters mapOsmExtractConfig(NodeAdapter config) {
        OsmExtractParametersBuilder builder = new OsmExtractParametersBuilder();
        builder.withSource(OsmConfig.mapSource(config));
        builder.withTimeZone(OsmConfig.mapTimeZone(config));
        builder.withOsmTagMapper(OsmConfig.mapTagMapping(config));
        return builder.build();
    }

    private static URI mapSource(NodeAdapter config) {
        return config.of("source").since(OtpVersion.V2_2).summary("The unique URI pointing to the data file.").asUri();
    }

    private static ZoneId mapTimeZone(NodeAdapter config) {
        return config.of("timeZone").since(OtpVersion.V2_2).summary("The timezone used to resolve opening hours in OSM data. Overrides the value specified in osmDefaults.").asZoneId(null);
    }

    private static OsmTagMapper mapTagMapping(NodeAdapter node) {
        return node.of("osmTagMapping").since(OtpVersion.V2_2).summary("The named set of mapping rules applied when parsing OSM tags.").asEnum(OsmTagMapper.Source.DEFAULT).getInstance();
    }
}

