/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config.buildconfig;

import org.opentripplanner.graph_builder.module.ned.parameter.DemExtractParameters;
import org.opentripplanner.graph_builder.module.ned.parameter.DemExtractParametersBuilder;
import org.opentripplanner.graph_builder.module.ned.parameter.DemExtractParametersList;
import org.opentripplanner.standalone.config.framework.json.NodeAdapter;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;

public class DemConfig {
    public static DemExtractParametersList mapDemConfig(NodeAdapter root, String parameterName) {
        return new DemExtractParametersList(root.of(parameterName).since(OtpVersion.V2_2).summary("Specify parameters for DEM extracts.").description("The dem section allows you to override the default behavior of scanning for elevation\nfiles in the [base directory](Configuration.md#Base-Directory). You can specify data\nlocated outside the local filesystem (including cloud storage services) or at various\ndifferent locations around the local filesystem.\n\nIf not specified OTP will fall back to auto-detection based on the directory provided on\nthe command line.\n").asObjects(DemConfig::mapDemExtract));
    }

    private static DemExtractParameters mapDemExtract(NodeAdapter config) {
        return new DemExtractParametersBuilder().withSource(config.of("source").since(OtpVersion.V2_2).summary("The unique URI pointing to the data file.").asUri()).withElevationUnitMultiplier(config.of("elevationUnitMultiplier").since(OtpVersion.V2_2).summary("Specify a multiplier to convert elevation units from source to meters.").description("  Unit conversion multiplier for elevation values. No conversion needed if the elevation\n  values are defined in meters in the source data. If, for example, decimetres are used\n  in the source data, this should be set to 0.1. This overrides the value specified in\n  [`elevationUnitMultiplier`](#elevationUnitMultiplier) in the build config at root level.\n").asDoubleOptional().orElse(null)).build();
    }
}

