/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import javax.annotation.Nullable;
import org.opentripplanner.standalone.config.BuildConfig;
import org.opentripplanner.standalone.config.OtpConfig;
import org.opentripplanner.standalone.config.RouterConfig;
import org.opentripplanner.standalone.config.framework.file.ConfigFileLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OtpConfigLoader {
    private static final Logger LOG = LoggerFactory.getLogger(OtpConfigLoader.class);
    private static final String OTP_CONFIG_FILENAME = "otp-config.json";
    private static final String BUILD_CONFIG_FILENAME = "build-config.json";
    private static final String ROUTER_CONFIG_FILENAME = "router-config.json";
    @Nullable
    private final File configDir;
    @Nullable
    private final String jsonFallback;

    private OtpConfigLoader(File configDir, String jsonFallback) {
        this.configDir = configDir;
        this.jsonFallback = jsonFallback;
    }

    public OtpConfigLoader(File configDir) {
        this(configDir, null);
    }

    public static OtpConfigLoader fromString(String json) {
        return new OtpConfigLoader(null, json);
    }

    public static boolean isConfigFile(String filename) {
        return OTP_CONFIG_FILENAME.equals(filename) || BUILD_CONFIG_FILENAME.equals(filename) || ROUTER_CONFIG_FILENAME.equals(filename);
    }

    public static void logConfigVersion(String otpConfigVersion, String buildConfigVersion, String routerConfigVersion) {
        OtpConfigLoader.logConfigVersion(otpConfigVersion, OTP_CONFIG_FILENAME);
        OtpConfigLoader.logConfigVersion(buildConfigVersion, BUILD_CONFIG_FILENAME);
        OtpConfigLoader.logConfigVersion(routerConfigVersion, ROUTER_CONFIG_FILENAME);
    }

    public OtpConfig loadOtpConfig() {
        return new OtpConfig(this.loadFromFile(OTP_CONFIG_FILENAME), OTP_CONFIG_FILENAME, true);
    }

    public BuildConfig loadBuildConfig() {
        JsonNode node = this.loadFromFile(BUILD_CONFIG_FILENAME);
        if (node.isMissingNode()) {
            return BuildConfig.DEFAULT;
        }
        return new BuildConfig(node, BUILD_CONFIG_FILENAME, true);
    }

    public RouterConfig loadRouterConfig() {
        JsonNode node = this.loadFromFile(ROUTER_CONFIG_FILENAME);
        if (node.isMissingNode()) {
            return RouterConfig.DEFAULT;
        }
        return new RouterConfig(node, ROUTER_CONFIG_FILENAME, true);
    }

    private static void logConfigVersion(String configVersion, String filename) {
        if (configVersion != null) {
            LOG.info("{} config-version is {}.", (Object)filename, (Object)configVersion);
        }
    }

    private JsonNode loadFromFile(String filename) {
        return ConfigFileLoader.of().withConfigDir(this.configDir).withJsonFallback(this.jsonFallback).loadFromFile(filename);
    }
}

