/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import java.net.URI;
import java.time.Duration;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.opentripplanner.datastore.api.OtpDataStoreConfig;
import org.opentripplanner.ext.dataoverlay.configuration.DataOverlayConfig;
import org.opentripplanner.ext.fares.FaresConfiguration;
import org.opentripplanner.graph_builder.module.ned.parameter.DemExtractParametersList;
import org.opentripplanner.graph_builder.module.osm.parameters.OsmDefaultParameters;
import org.opentripplanner.graph_builder.module.osm.parameters.OsmExtractParametersList;
import org.opentripplanner.graph_builder.services.osm.CustomNamer;
import org.opentripplanner.model.calendar.ServiceDateInterval;
import org.opentripplanner.netex.config.NetexFeedParameters;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.fares.FareServiceFactory;
import org.opentripplanner.standalone.config.buildconfig.DemConfig;
import org.opentripplanner.standalone.config.buildconfig.NetexConfig;
import org.opentripplanner.standalone.config.buildconfig.OsmConfig;
import org.opentripplanner.standalone.config.buildconfig.S3BucketConfig;
import org.opentripplanner.standalone.config.buildconfig.TransferRequestConfig;
import org.opentripplanner.standalone.config.buildconfig.TransitFeedConfig;
import org.opentripplanner.standalone.config.buildconfig.TransitFeeds;
import org.opentripplanner.standalone.config.framework.json.NodeAdapter;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;
import org.opentripplanner.standalone.config.sandbox.DataOverlayConfigMapper;
import org.opentripplanner.util.lang.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildConfig
implements OtpDataStoreConfig {
    private static final Logger LOG = LoggerFactory.getLogger(BuildConfig.class);
    public static final BuildConfig DEFAULT = new BuildConfig((JsonNode)MissingNode.getInstance(), "DEFAULT", false);
    private static final double DEFAULT_SUBWAY_ACCESS_TIME_MINUTES = 2.0;
    private static final String DEFAULT_GTFS_PATTERN = "(?i)gtfs";
    private static final String DEFAULT_NETEX_PATTERN = "(?i)netex";
    private static final String DEFAULT_OSM_PATTERN = "(?i)(\\.pbf|\\.osm|\\.osm\\.xml)$";
    private static final String DEFAULT_DEM_PATTERN = "(?i)\\.tiff?$";
    private final NodeAdapter root;
    public final String configVersion;
    public final boolean dataImportReport;
    public final int maxDataImportIssuesPerFile;
    public final double subwayAccessTime;
    public final boolean embedRouterConfig;
    public final boolean areaVisibility;
    public final boolean platformEntriesLinking;
    public final boolean matchBusRoutesToStreets;
    public final S3BucketConfig elevationBucket;
    public final double elevationUnitMultiplier;
    public final FareServiceFactory fareServiceFactory;
    private final Pattern netexLocalFilePattern;
    private final Pattern gtfsLocalFilePattern;
    private final Pattern osmLocalFilePattern;
    private final Pattern demLocalFilePattern;
    private final String gsCredentials;
    private final URI streetGraph;
    private final URI graph;
    private final URI buildReportDir;
    public final CustomNamer customNamer;
    public final boolean osmCacheDataInMem;
    public final int pruningThresholdIslandWithoutStops;
    public final int pruningThresholdIslandWithStops;
    public final boolean banDiscouragedWalking;
    public final boolean banDiscouragedBiking;
    public final double maxTransferDurationSeconds;
    public final Boolean extraEdgesStopPlatformLink;
    public final NetexFeedParameters netexDefaults;
    public final OsmDefaultParameters osmDefaults;
    public final List<RouteRequest> transferRequests;
    public final int maxAreaNodes;
    public final DataOverlayConfig dataOverlay;
    public final double maxStopToShapeSnapDistance;
    public final Set<String> boardingLocationTags;
    public final DemExtractParametersList dem;
    public final OsmExtractParametersList osm;
    public final TransitFeeds transitFeeds;
    public boolean staticParkAndRide;
    public boolean staticBikeParkAndRide;
    public int maxInterlineDistance;
    public double distanceBetweenElevationSamples;
    public double maxElevationPropagationMeters;
    public boolean readCachedElevations;
    public boolean writeCachedElevations;
    public boolean includeEllipsoidToGeoidDifference;
    public boolean multiThreadElevationCalculations;
    public LocalDate transitServiceStart;
    public LocalDate transitServiceEnd;
    public boolean discardMinTransferTimes;
    public ZoneId transitModelTimeZone;
    public boolean blockBasedInterlining;

    public BuildConfig(JsonNode node, String source, boolean logUnusedParams) {
        this(new NodeAdapter(node, source), logUnusedParams);
    }

    public BuildConfig(NodeAdapter root, boolean logUnusedParams) {
        this.root = root;
        this.areaVisibility = root.of("areaVisibility").since(OtpVersion.V1_5).summary("Perform visibility calculations.").description("If this is `true` OTP attempts to calculate a path straight through an OSM area using the\nshortest way rather than around the edge of it. (These calculations can be time consuming).\n").asBoolean(false);
        this.banDiscouragedWalking = root.of("banDiscouragedWalking").since(OtpVersion.V2_0).summary("Should walking be allowed on OSM ways tagged with `foot=discouraged`").asBoolean(false);
        this.banDiscouragedBiking = root.of("banDiscouragedBiking").since(OtpVersion.V2_0).summary("Should biking be allowed on OSM ways tagged with `bicycle=discouraged`").asBoolean(false);
        this.configVersion = root.of("configVersion").since(OtpVersion.V2_1).summary("Deployment version of the *build-config.json*.").description("The config-version is a parameter which each OTP deployment may set to be able to query the\nOTP server and verify that it uses the correct version of the config. The version should be\ninjected into the config in the (continuous) deployment pipeline. How this is done, is up to\nthe deployment.\n\nThe config-version has no effect on OTP, and is provided as is on the API. There is no syntax\nor format check on the version and it can be any string.\n\nBe aware that OTP uses the config embedded in the loaded graph if no new config is provided.\n").asString(null);
        this.dataImportReport = root.of("dataImportReport").since(OtpVersion.V2_0).summary("Generate nice HTML report of Graph errors/warnings").description("The reports are stored in the same location as the graph.").asBoolean(false);
        this.distanceBetweenElevationSamples = root.of("distanceBetweenElevationSamples").since(OtpVersion.V2_0).summary("The distance between elevation samples in meters.").description("The default is the approximate resolution of 1/3 arc-second NED data. This should not be smaller than the horizontal resolution of the height data used.").asDouble(10.0);
        this.elevationBucket = S3BucketConfig.fromConfig(root, "elevationBucket");
        this.elevationUnitMultiplier = root.of("elevationUnitMultiplier").since(OtpVersion.V2_0).summary("Specify a multiplier to convert elevation units from source to meters.").description("Unit conversion multiplier for elevation values. No conversion needed if the elevation\nvalues are defined in meters in the source data. If, for example, decimetres are used\nin the source data, this should be set to 0.1.\n").asDouble(1.0);
        this.embedRouterConfig = root.of("embedRouterConfig").since(OtpVersion.V2_0).summary("Embed the Router config in the graph, which allows it to be sent to a server fully configured over the wire.").asBoolean(true);
        this.extraEdgesStopPlatformLink = root.of("extraEdgesStopPlatformLink").since(OtpVersion.V2_0).summary("Add extra edges when linking a stop to a platform, to prevent detours along the platform edge.").asBoolean(false);
        this.includeEllipsoidToGeoidDifference = root.of("includeEllipsoidToGeoidDifference").since(OtpVersion.V2_0).summary("Include the Ellipsoid to Geoid difference in the calculations of every point along every StreetWithElevationEdge.").description("When set to true (it is false by default), the elevation module will include the Ellipsoid to\nGeoid difference in the calculations of every point along every StreetWithElevationEdge in the\ngraph.\n\nNOTE: if this is set to true for graph building, make sure to not set the value of\n`RoutingResource#geoidElevation` to true otherwise OTP will add this geoid value again to\nall of the elevation values in the street edges.\n").asBoolean(false);
        this.pruningThresholdIslandWithStops = root.of("islandWithStopsMaxSize").since(OtpVersion.V2_1).summary("When a graph island with stops in it should be pruned.").description("This field indicates the pruning threshold for islands with stops. Any such island under this\nsize will be pruned.\n").asInt(5);
        this.pruningThresholdIslandWithoutStops = root.of("islandWithoutStopsMaxSize").since(OtpVersion.V2_1).summary("When a graph island without stops should be pruned.").description("This field indicates the pruning threshold for islands without stops. Any such island under\nthis size will be pruned.\n").asInt(40);
        this.matchBusRoutesToStreets = root.of("matchBusRoutesToStreets").since(OtpVersion.V1_5).summary("Based on GTFS shape data, guess which OSM streets each bus runs on to improve stop linking.").asBoolean(false);
        this.maxDataImportIssuesPerFile = root.of("maxDataImportIssuesPerFile").since(OtpVersion.V2_0).summary("When to split the import report.").description("  If the number of issues is larger then `maxDataImportIssuesPerFile`, then the files will\n  be split in multiple files. Since browsers have problems opening large HTML files.\n").asInt(1000);
        this.maxInterlineDistance = root.of("maxInterlineDistance").since(OtpVersion.V1_5).summary("Maximal distance between stops in meters that will connect consecutive trips that are made with same vehicle.").asInt(200);
        this.blockBasedInterlining = root.of("blockBasedInterlining").since(OtpVersion.V2_2).summary("Whether to create stay-seated transfers in between two trips with the same block id.").asBoolean(true);
        this.maxTransferDurationSeconds = root.of("maxTransferDurationSeconds").since(OtpVersion.V2_1).summary("Transfers up to this duration with the default walk speed value will be pre-calculated and included in the Graph.").asDouble(Duration.ofMinutes(30L).toSeconds());
        this.maxStopToShapeSnapDistance = root.of("maxStopToShapeSnapDistance").since(OtpVersion.V2_1).summary("Maximum distance between route shapes and their stops.").description("This field is used for mapping routes geometry shapes. It determines max distance between shape\npoints and their stop sequence. If mapper cannot find any stops within this radius it will\ndefault to simple stop-to-stop geometry instead.\n").asDouble(150.0);
        this.multiThreadElevationCalculations = root.of("multiThreadElevationCalculations").since(OtpVersion.V2_0).summary("Configuring multi-threading during elevation calculations.").description("  For unknown reasons that seem to depend on data and machine settings, it might be faster\n  to use a single processor. If multi-threading is activated, parallel streams will be used\n  to calculate the elevations.\n").asBoolean(false);
        this.osmCacheDataInMem = root.of("osmCacheDataInMem").since(OtpVersion.V2_0).summary("If OSM data should be cached in memory during processing.").description("When loading OSM data, the input is streamed 3 times - one phase for processing RELATIONS, one\nfor WAYS and last one for NODES. Instead of reading the data source 3 times it might be faster\nto cache the entire osm file im memory. The trade off is of course that OTP might use more\nmemory while loading osm data. You can use this parameter to choose what is best for your\ndeployment depending on your infrastructure. Set the parameter to `true` to cache the\ndata, and to `false` to read the stream from the source each time.\n").asBoolean(false);
        this.platformEntriesLinking = root.of("platformEntriesLinking").since(OtpVersion.V2_0).summary("Link unconnected entries to public transport platforms.").asBoolean(false);
        this.readCachedElevations = root.of("readCachedElevations").since(OtpVersion.V2_0).summary("Whether to read cached elevation data.").description("When set to true, the elevation module will attempt to read this file in\norder to reuse calculations of elevation data for various coordinate sequences instead of\nrecalculating them all over again.\n").asBoolean(true);
        this.staticBikeParkAndRide = root.of("staticBikeParkAndRide").since(OtpVersion.V1_5).summary("Whether we should create bike P+R stations from OSM data.").asBoolean(false);
        this.staticParkAndRide = root.of("staticParkAndRide").since(OtpVersion.V1_5).summary("Whether we should create car P+R stations from OSM data.").asBoolean(true);
        this.subwayAccessTime = root.of("subwayAccessTime").since(OtpVersion.V1_5).summary("Minutes necessary to reach stops served by trips on routes of route_type=1 (subway) from the street.").description("Note! The preferred way to do this is to update the OSM data.\nSee [Transferring within stations](#transferring-within-stations).\n\nThe ride locations for some modes of transport such as subways can be slow to reach from the street.\nWhen planning a trip, we need to allow additional time to reach these locations to properly inform\nthe passenger. For example, this helps avoid suggesting short bus rides between two subway rides as\na way to improve travel time. You can specify how long it takes to reach a subway platform.\n\nThis setting does not generalize to other modes like airplanes because you often need much longer time\nto check in to a flight (2-3 hours for international flights) than to alight and exit the airport\n(perhaps 1 hour). Use [`boardSlackForMode`](RouteRequest.md#rd_boardSlackForMode) and\n[`alightSlackForMode`](RouteRequest.md#rd_alightSlackForMode) for this.\n").asDouble(2.0);
        this.transitModelTimeZone = root.of("transitModelTimeZone").since(OtpVersion.V2_2).summary("Time zone for the graph.").description("This is used to store the timetables in the transit model, and to interpret times in incoming requests.").asZoneId(null);
        ZoneId confZone = ObjectUtils.ifNotNull(this.transitModelTimeZone, ZoneId.systemDefault());
        this.transitServiceStart = root.of("transitServiceStart").since(OtpVersion.V2_0).summary("Limit the import of transit services to the given START date.").description("See [Limit the transit service period](#limit-transit-service-period) for an introduction.\n\nThe date is inclusive. If set, any transit service on a day BEFORE the given date is dropped and\nwill not be part of the graph. Use an absolute date or a period relative to the date the graph is\nbuild(BUILD_DAY).\n\nUse an empty string to make unbounded.\n").asDateOrRelativePeriod("-P1Y", confZone);
        this.transitServiceEnd = root.of("transitServiceEnd").since(OtpVersion.V2_0).summary("Limit the import of transit services to the given end date.").description("See [Limit the transit service period](#limit-transit-service-period) for an introduction.\n\nThe date is inclusive. If set, any transit service on a day AFTER the given date is dropped and\nwill not be part of the graph. Use an absolute date or a period relative to the date the graph is\nbuild(BUILD_DAY).\n\nUse an empty string to make it unbounded.\n").asDateOrRelativePeriod("P3Y", confZone);
        this.writeCachedElevations = root.of("writeCachedElevations").since(OtpVersion.V2_0).summary("Reusing elevation data from previous builds").description("When set to true, the elevation module will create a file cache for calculated elevation data.\nSubsequent graph builds can reuse the data in this file.\n\nAfter building the graph, a file called `cached_elevations.obj` will be written to the cache\ndirectory. By default, this file is not written during graph builds. There is also a graph build\nparameter called `readCachedElevations` which is set to `true` by default.\n\nIn graph builds, the elevation module will attempt to read the `cached_elevations.obj` file from\nthe cache directory. The cache directory defaults to `/var/otp/cache`, but this can be overridden\nvia the CLI argument `--cache <directory>`. For the same graph build for multiple Northeast US\nstates, the time it took with using this pre-downloaded and precalculated data became roughly 9\nminutes.\n\nThe cached data is a lookup table where the coordinate sequences of respective street edges are\nused as keys for calculated data. It is assumed that all of the other input data except for the\nOpenStreetMap data remains the same between graph builds. Therefore, if the underlying elevation\ndata is changed, or different configuration values for `elevationUnitMultiplier` or\n`includeEllipsoidToGeoidDifference` are used, then this data becomes invalid and all elevation data\nshould be recalculated. Over time, various edits to OpenStreetMap will cause this cached data to\nbecome stale and not include new OSM ways. Therefore, periodic update of this cached data is\nrecommended.\n").asBoolean(false);
        this.maxAreaNodes = root.of("maxAreaNodes").since(OtpVersion.V2_1).summary("Visibility calculations for an area will not be done if there are more nodes than this limit.").asInt(500);
        this.maxElevationPropagationMeters = root.of("maxElevationPropagationMeters").since(OtpVersion.V1_5).summary("The maximum distance to propagate elevation to vertices which have no elevation.").asInt(2000);
        this.boardingLocationTags = root.of("boardingLocationTags").since(OtpVersion.V2_2).summary("What OSM tags should be looked on for the source of matching stops to platforms and stops.").description("[Detailed documentation](BoardingLocations.md)").asStringSet(List.copyOf(Set.of("ref")));
        this.discardMinTransferTimes = root.of("discardMinTransferTimes").since(OtpVersion.V2_2).summary("Should minimum transfer times in GTFS files be discarded.").description("This is useful eg. when the minimum transfer time is only set for ticketing purposes,\nbut we want to calculate the transfers always from OSM data.\n").asBoolean(false);
        NodeAdapter localFileNamePatternsConfig = root.of("localFileNamePatterns").since(OtpVersion.V2_0).summary("Patterns for matching OTP file types in the base directory").description("When scanning the base directory for inputs, each file's name is checked against patterns to\ndetect what kind of file it is.\n\nOTP1 used to peek inside ZIP files and read the CSV tables to guess if a ZIP was indeed GTFS. Now\nthat we support remote input files (cloud storage or arbitrary URLs) not all data sources allow\nseeking within files to guess what they are. Therefore, like all other file types GTFS is now\ndetected from a filename pattern. It is not sufficient to look for the `.zip` extension because\nNetex data is also often supplied in a ZIP file.\n").asObject();
        this.gtfsLocalFilePattern = localFileNamePatternsConfig.of("gtfs").since(OtpVersion.V2_0).summary("Patterns for matching GTFS zip-files or directories.").description("If the filename contains the given pattern it is considered a match.\nAny legal Java Regular expression is allowed.\n").asPattern(DEFAULT_GTFS_PATTERN);
        this.netexLocalFilePattern = localFileNamePatternsConfig.of("netex").since(OtpVersion.V2_0).summary("Patterns for matching NeTEx zip files or directories.").description("If the filename contains the given\npattern it is considered a match. Any legal Java Regular expression is allowed.\n").asPattern(DEFAULT_NETEX_PATTERN);
        this.osmLocalFilePattern = localFileNamePatternsConfig.of("osm").since(OtpVersion.V2_0).summary("Pattern for matching Open Street Map input files.").description("If the filename contains the given pattern\nit is considered a match. Any legal Java Regular expression is allowed.\n").asPattern(DEFAULT_OSM_PATTERN);
        this.demLocalFilePattern = localFileNamePatternsConfig.of("dem").since(OtpVersion.V2_0).summary("Pattern for matching elevation DEM files.").description("If the filename contains the given pattern it is\nconsidered a match. Any legal Java Regular expression is allowed.\n").asPattern(DEFAULT_DEM_PATTERN);
        this.gsCredentials = root.of("gsCredentials").since(OtpVersion.V2_0).summary("Local file system path to Google Cloud Platform service accounts credentials file.").description("The credentials is used to access GCS urls. When using GCS from outside of Google Cloud you\nneed to provide a path the the service credentials. Environment variables in the path are\nresolved.\n\nThis is a path to a file on the local file system, not an URI.\n").asString(null);
        this.graph = root.of("graph").since(OtpVersion.V2_0).summary("URI to the graph object file for reading and writing.").description("The file is created or overwritten if OTP saves the graph to the file.").asUri(null);
        this.streetGraph = root.of("streetGraph").since(OtpVersion.V2_0).summary("URI to the street graph object file for reading and writing.").description("The file is created or overwritten if OTP saves the graph to the file").asUri(null);
        this.buildReportDir = root.of("buildReportDir").since(OtpVersion.V2_0).summary("URI to the directory where the graph build report should be written to.").description("The html report is written into this directory. If the directory exist, any existing files are deleted.\nIf it does not exist, it is created.\n").asUri(null);
        this.osmDefaults = OsmConfig.mapOsmDefaults(root, "osmDefaults");
        this.osm = OsmConfig.mapOsmConfig(root, "osm");
        this.dem = DemConfig.mapDemConfig(root, "dem");
        this.netexDefaults = NetexConfig.mapNetexDefaultParameters(root, "netexDefaults");
        this.transitFeeds = TransitFeedConfig.mapTransitFeeds(root, "transitFeeds", this.netexDefaults);
        this.fareServiceFactory = FaresConfiguration.fromConfig(root, "fares");
        this.customNamer = CustomNamer.CustomNamerFactory.fromConfig(root, "osmNaming");
        this.dataOverlay = DataOverlayConfigMapper.map(root, "dataOverlay");
        this.transferRequests = TransferRequestConfig.map(root, "transferRequests");
        if (logUnusedParams && LOG.isWarnEnabled()) {
            root.logAllUnusedParameters(arg_0 -> ((Logger)LOG).warn(arg_0));
        }
    }

    @Override
    public URI reportDirectory() {
        return this.buildReportDir;
    }

    @Override
    public String gsCredentials() {
        return this.gsCredentials;
    }

    @Override
    public List<URI> osmFiles() {
        return this.osm.osmFiles();
    }

    @Override
    public List<URI> demFiles() {
        return this.dem.demFiles();
    }

    @Override
    @Nonnull
    public List<URI> gtfsFiles() {
        return this.transitFeeds.gtfsFiles();
    }

    @Override
    @Nonnull
    public List<URI> netexFiles() {
        return this.transitFeeds.netexFiles();
    }

    @Override
    public URI graph() {
        return this.graph;
    }

    @Override
    public URI streetGraph() {
        return this.streetGraph;
    }

    @Override
    public Pattern gtfsLocalFilePattern() {
        return this.gtfsLocalFilePattern;
    }

    @Override
    public Pattern netexLocalFilePattern() {
        return this.netexLocalFilePattern;
    }

    @Override
    public Pattern osmLocalFilePattern() {
        return this.osmLocalFilePattern;
    }

    @Override
    public Pattern demLocalFilePattern() {
        return this.demLocalFilePattern;
    }

    public boolean isDefault() {
        return this.root.isEmpty();
    }

    public String toJson() {
        return this.root.isEmpty() ? "" : this.root.toJson();
    }

    public ServiceDateInterval getTransitServicePeriod() {
        return new ServiceDateInterval(this.transitServiceStart, this.transitServiceEnd);
    }

    public int getSubwayAccessTimeSeconds() {
        return (int)(this.subwayAccessTime * 60.0);
    }

    public NodeAdapter asNodeAdapter() {
        return this.root;
    }
}

