/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.api;

import io.micrometer.core.instrument.MeterRegistry;
import java.util.Locale;
import org.opentripplanner.ext.dataoverlay.routing.DataOverlayContext;
import org.opentripplanner.inspector.TileRendererManager;
import org.opentripplanner.routing.RoutingService;
import org.opentripplanner.routing.algorithm.astar.TraverseVisitor;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripSchedule;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graphfinder.GraphFinder;
import org.opentripplanner.standalone.config.RouterConfig;
import org.opentripplanner.transit.raptor.configure.RaptorConfig;
import org.opentripplanner.transit.service.TransitService;
import org.opentripplanner.util.OTPFeature;
import org.slf4j.Logger;

public interface OtpServerRequestContext {
    public RouteRequest defaultRouteRequest();

    public Locale defaultLocale();

    public RouterConfig routerConfig();

    public RaptorConfig<TripSchedule> raptorConfig();

    public Graph graph();

    public TransitService transitService();

    public RoutingService routingService();

    public MeterRegistry meterRegistry();

    public Logger requestLogger();

    public TileRendererManager tileRendererManager();

    public TraverseVisitor traverseVisitor();

    default public GraphFinder graphFinder() {
        return GraphFinder.getInstance(this.graph(), this.transitService()::findRegularStop);
    }

    default public DataOverlayContext dataOverlayContext(RouteRequest request) {
        return OTPFeature.DataOverlay.isOnElseNull(() -> new DataOverlayContext(this.graph().dataOverlayParameterBindings, request.preferences().system().dataOverlay()));
    }
}

