/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import org.geotools.referencing.factory.DeferredAuthorityFactory;
import org.geotools.util.WeakCollectionCleaner;
import org.opentripplanner.graph_builder.GraphBuilder;
import org.opentripplanner.model.projectinfo.OtpProjectInfo;
import org.opentripplanner.routing.graph.SerializedGraphObject;
import org.opentripplanner.standalone.OtpStartupInfo;
import org.opentripplanner.standalone.config.CommandLineParameters;
import org.opentripplanner.standalone.config.ConfigModel;
import org.opentripplanner.standalone.configure.ConstructApplication;
import org.opentripplanner.standalone.configure.LoadApplication;
import org.opentripplanner.standalone.server.GrizzlyServer;
import org.opentripplanner.transit.raptor.configure.RaptorConfig;
import org.opentripplanner.transit.service.TransitModel;
import org.opentripplanner.updater.configure.UpdaterConfigurator;
import org.opentripplanner.util.OtpAppException;
import org.opentripplanner.util.ThrowableUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class OTPMain {
    private static final Logger LOG = LoggerFactory.getLogger(OTPMain.class);

    public static void main(String[] args) {
        try {
            CommandLineParameters params = OTPMain.parseAndValidateCmdLine(args);
            OtpStartupInfo.logInfo();
            OTPMain.startOTPServer(params);
        }
        catch (OtpAppException ae) {
            LOG.error(ae.getMessage(), (Throwable)ae);
            System.exit(100);
        }
        catch (Exception e) {
            LOG.error("An uncaught error occurred inside OTP: {}", (Object)e.getLocalizedMessage(), (Object)e);
            System.exit(-1);
        }
    }

    private static CommandLineParameters parseAndValidateCmdLine(String[] args) {
        CommandLineParameters params = new CommandLineParameters();
        try {
            JCommander jc = JCommander.newBuilder().addObject((Object)params).args(args).build();
            if (params.version) {
                System.out.println("OpenTripPlanner " + OtpProjectInfo.projectInfo().getVersionString());
                System.exit(0);
            }
            if (params.serializationVersionId) {
                System.out.println(OtpProjectInfo.projectInfo().getOtpSerializationVersionId());
                System.exit(0);
            }
            if (params.help) {
                System.out.println("OpenTripPlanner " + OtpProjectInfo.projectInfo().getVersionString());
                jc.setProgramName("java -Xmx4G -jar otp.jar");
                jc.usage();
                System.exit(0);
            }
            params.inferAndValidate();
        }
        catch (ParameterException pex) {
            LOG.error("Parameter error: {}", (Object)pex.getMessage());
            System.exit(1);
        }
        return params;
    }

    private static void startOTPServer(CommandLineParameters cli) {
        boolean graphAvailable = false;
        LOG.info("Searching for configuration and input files in {}", (Object)cli.getBaseDirectory().getAbsolutePath());
        LoadApplication loadApp = new LoadApplication(cli);
        ConfigModel config = loadApp.config();
        loadApp.validateConfigAndDataSources();
        ConstructApplication app = null;
        if (cli.doLoadGraph() || cli.doLoadStreetGraph()) {
            SerializedGraphObject obj = SerializedGraphObject.load(loadApp.getInputGraphDataStore());
            app = loadApp.appConstruction(obj);
            config.updateConfigFromSerializedGraph(obj.buildConfig, obj.routerConfig);
            graphAvailable = true;
        } else {
            app = loadApp.appConstruction();
        }
        if (cli.doBuildStreet() || cli.doBuildTransit()) {
            SerializedGraphObject.verifyTheOutputGraphIsWritableIfDataSourceExist(app.graphOutputDataSource());
            GraphBuilder graphBuilder = app.createGraphBuilder();
            if (graphBuilder == null) {
                throw new IllegalStateException("An error occurred while building the graph.");
            }
            graphBuilder.run();
            graphAvailable = true;
            new SerializedGraphObject(app.graph(), app.transitModel(), config.buildConfig(), config.routerConfig()).save(app.graphOutputDataSource());
            LOG.info("Memory optimized {}", (Object)app.graph().deduplicator.toString());
        }
        if (!graphAvailable) {
            LOG.error("Nothing to do, no graph loaded or build. Exiting.");
            System.exit(101);
        }
        if (cli.doServe()) {
            OTPMain.startOtpWebServer(cli, app);
        } else {
            LOG.info("Done building graph. Exiting.");
        }
    }

    private static void startOtpWebServer(CommandLineParameters params, ConstructApplication app) {
        app.transitModel().index();
        app.graph().index(app.transitModel().getStopModel());
        OTPMain.setOtpConfigVersionsOnServerInfo(app);
        if (params.visualize) {
            app.graphVisualizer().run();
        }
        if (params.doServe()) {
            GrizzlyServer grizzlyServer = app.createGrizzlyServer();
            OTPMain.registerShutdownHookToGracefullyShutDownServer(app.transitModel(), app.raptorConfig());
            while (true) {
                try {
                    grizzlyServer.run();
                    return;
                }
                catch (Throwable throwable) {
                    LOG.error("An uncaught error occurred inside OTP. Restarting server. Error was: {}", (Object)ThrowableUtils.detailedString(throwable));
                    OTPMain.logLocationOfRequestLog(app.routerConfig().requestLogFile());
                    continue;
                }
                break;
            }
        }
    }

    private static void registerShutdownHookToGracefullyShutDownServer(TransitModel transitModel, RaptorConfig<?> raptorConfig) {
        Thread hook = new Thread(() -> {
            LOG.info("OTP shutdown started...");
            UpdaterConfigurator.shutdownGraph(transitModel);
            raptorConfig.shutdown();
            WeakCollectionCleaner.DEFAULT.exit();
            DeferredAuthorityFactory.exit();
        });
        Runtime.getRuntime().addShutdownHook(hook);
    }

    private static void logLocationOfRequestLog(String requestLogFile) {
        if (requestLogFile != null) {
            LOG.info("Logging incoming requests at '{}'", (Object)requestLogFile);
        } else {
            LOG.info("Incoming requests will not be logged.");
        }
    }

    private static void setOtpConfigVersionsOnServerInfo(ConstructApplication app) {
        OtpProjectInfo.projectInfo().otpConfigVersion = app.otpConfig().configVersion;
        OtpProjectInfo.projectInfo().buildConfigVersion = app.buildConfig().configVersion;
        OtpProjectInfo.projectInfo().routerConfigVersion = app.routerConfig().getConfigVersion();
    }

    static {
        System.setProperty("hsqldb.reconfig_logging", "false");
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
    }
}

