/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.vertextype;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.locationtech.jts.geom.Coordinate;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.routing.edgetype.StreetEdge;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.transit.model.basic.I18NString;
import org.opentripplanner.transit.model.basic.LocalizedString;
import org.opentripplanner.transit.model.site.AreaStop;

public abstract class StreetVertex
extends Vertex {
    private static final long serialVersionUID = 1L;
    public Set<AreaStop> areaStops;

    public StreetVertex(Graph g, String label, Coordinate coord, I18NString streetName) {
        this(g, label, coord.x, coord.y, streetName);
    }

    public StreetVertex(Graph g, String label, double x, double y, I18NString streetName) {
        super(g, label, x, y, streetName);
    }

    public I18NString getIntersectionName() {
        HashSet<I18NString> uniqueNameSet = new HashSet<I18NString>();
        for (Edge e : this.getOutgoing()) {
            if (!(e instanceof StreetEdge)) continue;
            uniqueNameSet.add(e.getName());
        }
        ArrayList uniqueNames = new ArrayList(uniqueNameSet);
        if (uniqueNames.size() > 1) {
            return new LocalizedString("corner", (I18NString)uniqueNames.get(0), (I18NString)uniqueNames.get(1));
        }
        if (uniqueNames.size() == 1) {
            return (I18NString)uniqueNames.get(0);
        }
        return new LocalizedString("unnamedStreet");
    }

    public boolean isConnectedToWalkingEdge() {
        return this.getOutgoing().stream().anyMatch(edge -> edge instanceof StreetEdge && ((StreetEdge)edge).getPermission().allows(TraverseMode.WALK));
    }

    public boolean isConnectedToDriveableEdge() {
        return this.getOutgoing().stream().anyMatch(edge -> edge instanceof StreetEdge && ((StreetEdge)edge).getPermission().allows(TraverseMode.CAR));
    }

    public boolean isEligibleForCarPickupDropoff() {
        return this.isConnectedToDriveableEdge() && this.isConnectedToWalkingEdge();
    }
}

