/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.vehicle_rental;

import java.time.Instant;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.locationtech.jts.geom.Geometry;
import org.opentripplanner.routing.vehicle_rental.RentalVehicleType;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalPlace;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalStationUris;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalSystem;
import org.opentripplanner.transit.model.basic.I18NString;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.util.lang.SetUtils;

public class VehicleRentalStation
implements VehicleRentalPlace {
    public FeedScopedId id;
    public I18NString name;
    public String shortName;
    public double longitude;
    public double latitude;
    public String address;
    public String crossStreet;
    public String regionId;
    public String postCode;
    public Set<String> rentalMethods;
    public boolean isVirtualStation = false;
    public Geometry stationArea;
    public Integer capacity;
    public Map<RentalVehicleType, Integer> vehicleTypeAreaCapacity;
    public Map<RentalVehicleType, Integer> vehicleTypeDockCapacity;
    public boolean isValetStation = false;
    public VehicleRentalSystem system;
    public VehicleRentalStationUris rentalUris;
    public int vehiclesAvailable = 0;
    public int vehiclesDisabled = 0;
    public Map<RentalVehicleType, Integer> vehicleTypesAvailable = Map.of();
    public int spacesAvailable = 0;
    public int spacesDisabled = 0;
    public Map<RentalVehicleType, Integer> vehicleSpacesAvailable = Map.of();
    public boolean isInstalled = true;
    public boolean isRenting = true;
    public boolean isReturning = true;
    public Instant lastReported;
    public boolean allowOverloading = false;
    public boolean isArrivingInRentalVehicleAtDestinationAllowed = false;
    public boolean realTimeData = true;

    @Override
    public FeedScopedId getId() {
        return this.id;
    }

    @Override
    public String getStationId() {
        return this.getId().getId();
    }

    @Override
    public String getNetwork() {
        return this.getId().getFeedId();
    }

    @Override
    public I18NString getName() {
        return this.name;
    }

    @Override
    public double getLongitude() {
        return this.longitude;
    }

    @Override
    public double getLatitude() {
        return this.latitude;
    }

    @Override
    public int getVehiclesAvailable() {
        return this.vehiclesAvailable;
    }

    @Override
    public int getSpacesAvailable() {
        return this.spacesAvailable;
    }

    @Override
    public Integer getCapacity() {
        return this.capacity;
    }

    @Override
    public boolean isAllowDropoff() {
        return this.isReturning;
    }

    @Override
    public boolean isAllowOverloading() {
        return this.allowOverloading;
    }

    @Override
    public boolean isAllowPickup() {
        return this.isRenting;
    }

    @Override
    public boolean allowPickupNow() {
        return this.isRenting && this.vehiclesAvailable > 0;
    }

    @Override
    public boolean allowDropoffNow() {
        return this.isReturning && (this.spacesAvailable > 0 || this.allowOverloading);
    }

    @Override
    public boolean isFloatingVehicle() {
        return false;
    }

    @Override
    public boolean isCarStation() {
        return Stream.concat(this.vehicleTypesAvailable.keySet().stream(), this.vehicleSpacesAvailable.keySet().stream()).anyMatch(rentalVehicleType -> rentalVehicleType.formFactor.equals((Object)RentalVehicleType.FormFactor.CAR));
    }

    @Override
    public Set<RentalVehicleType.FormFactor> getAvailablePickupFormFactors(boolean includeRealtimeAvailability) {
        return this.vehicleTypesAvailable.entrySet().stream().filter(e -> !includeRealtimeAvailability || (Integer)e.getValue() > 0).map(e -> ((RentalVehicleType)e.getKey()).formFactor).collect(Collectors.toSet());
    }

    @Override
    public Set<RentalVehicleType.FormFactor> getAvailableDropoffFormFactors(boolean includeRealtimeAvailability) {
        return this.vehicleSpacesAvailable.entrySet().stream().filter(e -> !includeRealtimeAvailability || (Integer)e.getValue() > 0).map(e -> ((RentalVehicleType)e.getKey()).formFactor).collect(Collectors.toSet());
    }

    @Override
    public boolean isArrivingInRentalVehicleAtDestinationAllowed() {
        return this.isArrivingInRentalVehicleAtDestinationAllowed;
    }

    @Override
    public boolean isRealTimeData() {
        return this.realTimeData;
    }

    @Override
    public VehicleRentalStationUris getRentalUris() {
        return this.rentalUris;
    }

    public String toString() {
        return String.format(Locale.ROOT, "Vehicle rental station %s at %.6f, %.6f", this.name, this.latitude, this.longitude);
    }

    public Set<RentalVehicleType.FormFactor> formFactors() {
        return SetUtils.combine(this.getAvailableDropoffFormFactors(false), this.getAvailablePickupFormFactors(false));
    }
}

