/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.vehicle_parking;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.opentripplanner.routing.vehicle_parking.VehicleParking;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingGroup;

public class VehicleParkingService
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Set<VehicleParking> vehicleParkings = Set.of();
    private ImmutableListMultimap<VehicleParkingGroup, VehicleParking> vehicleParkingGroups = ImmutableListMultimap.of();

    public void updateVehicleParking(Collection<VehicleParking> parkingToAdd, Collection<VehicleParking> parkingToRemove) {
        ArrayListMultimap updatedVehicleParkingGroups = ArrayListMultimap.create(this.vehicleParkingGroups);
        parkingToRemove.forEach(arg_0 -> VehicleParkingService.lambda$updateVehicleParking$0((Multimap)updatedVehicleParkingGroups, arg_0));
        parkingToAdd.forEach(arg_0 -> VehicleParkingService.lambda$updateVehicleParking$1((Multimap)updatedVehicleParkingGroups, arg_0));
        this.vehicleParkingGroups = ImmutableListMultimap.copyOf((Multimap)updatedVehicleParkingGroups);
        HashSet<VehicleParking> updatedVehicleParkings = new HashSet<VehicleParking>(this.vehicleParkings);
        updatedVehicleParkings.removeAll(parkingToRemove);
        updatedVehicleParkings.addAll(parkingToAdd);
        this.vehicleParkings = Set.copyOf(updatedVehicleParkings);
    }

    public Stream<VehicleParking> getBikeParks() {
        return this.vehicleParkings.stream().filter(VehicleParking::hasBicyclePlaces);
    }

    public Stream<VehicleParking> getCarParks() {
        return this.vehicleParkings.stream().filter(VehicleParking::hasAnyCarPlaces);
    }

    public Stream<VehicleParking> getVehicleParkings() {
        return this.vehicleParkings.stream();
    }

    public ImmutableListMultimap<VehicleParkingGroup, VehicleParking> getVehicleParkingGroups() {
        return this.vehicleParkingGroups;
    }

    private static /* synthetic */ void lambda$updateVehicleParking$1(Multimap updatedVehicleParkingGroups, VehicleParking vehicleParking) {
        VehicleParkingGroup vehicleParkingGroup = vehicleParking.getVehicleParkingGroup();
        if (vehicleParkingGroup != null) {
            updatedVehicleParkingGroups.put((Object)vehicleParking.getVehicleParkingGroup(), (Object)vehicleParking);
        }
    }

    private static /* synthetic */ void lambda$updateVehicleParking$0(Multimap updatedVehicleParkingGroups, VehicleParking vehicleParking) {
        VehicleParkingGroup vehicleParkingGroup = vehicleParking.getVehicleParkingGroup();
        if (vehicleParkingGroup != null) {
            updatedVehicleParkingGroups.remove((Object)vehicleParking.getVehicleParkingGroup(), (Object)vehicleParking);
        }
    }
}

