/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.vehicle_parking;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.opentripplanner.model.calendar.openinghours.OHCalendar;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingEntrance;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingGroup;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingSpaces;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingState;
import org.opentripplanner.transit.model.basic.I18NString;
import org.opentripplanner.transit.model.basic.WgsCoordinate;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.util.lang.ToStringBuilder;

public class VehicleParking
implements Serializable {
    private final FeedScopedId id;
    private final I18NString name;
    private final WgsCoordinate coordinate;
    private final String detailsUrl;
    private final String imageUrl;
    private final Set<String> tags;
    private final OHCalendar openingHoursCalendar;
    private final I18NString note;
    private final VehicleParkingState state;
    private final boolean bicyclePlaces;
    private final boolean carPlaces;
    private final boolean wheelchairAccessibleCarPlaces;
    private final VehicleParkingSpaces capacity;
    private final List<VehicleParkingEntrance> entrances = new ArrayList<VehicleParkingEntrance>();
    private VehicleParkingSpaces availability;
    private final VehicleParkingGroup vehicleParkingGroup;

    VehicleParking(FeedScopedId id, I18NString name, WgsCoordinate coordinate, String detailsUrl, String imageUrl, Set<String> tags, OHCalendar openingHoursCalendar, I18NString note, VehicleParkingState state, boolean bicyclePlaces, boolean carPlaces, boolean wheelchairAccessibleCarPlaces, VehicleParkingSpaces capacity, VehicleParkingSpaces availability, VehicleParkingGroup vehicleParkingGroup) {
        this.id = id;
        this.name = name;
        this.coordinate = coordinate;
        this.detailsUrl = detailsUrl;
        this.imageUrl = imageUrl;
        this.tags = tags;
        this.openingHoursCalendar = openingHoursCalendar;
        this.note = note;
        this.state = state;
        this.bicyclePlaces = bicyclePlaces;
        this.carPlaces = carPlaces;
        this.wheelchairAccessibleCarPlaces = wheelchairAccessibleCarPlaces;
        this.capacity = capacity;
        this.availability = availability;
        this.vehicleParkingGroup = vehicleParkingGroup;
    }

    public static VehicleParkingBuilder builder() {
        return new VehicleParkingBuilder();
    }

    public FeedScopedId getId() {
        return this.id;
    }

    @Nullable
    public I18NString getName() {
        return this.name;
    }

    public WgsCoordinate getCoordinate() {
        return this.coordinate;
    }

    public String getDetailsUrl() {
        return this.detailsUrl;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public OHCalendar getOpeningHours() {
        return this.openingHoursCalendar;
    }

    public I18NString getNote() {
        return this.note;
    }

    public VehicleParkingState getState() {
        return this.state;
    }

    public VehicleParkingSpaces getCapacity() {
        return this.capacity;
    }

    public VehicleParkingSpaces getAvailability() {
        return this.availability;
    }

    public List<VehicleParkingEntrance> getEntrances() {
        return this.entrances;
    }

    @Nullable
    public VehicleParkingGroup getVehicleParkingGroup() {
        return this.vehicleParkingGroup;
    }

    public boolean hasBicyclePlaces() {
        return this.bicyclePlaces;
    }

    public boolean hasAnyCarPlaces() {
        return this.hasCarPlaces() || this.hasWheelchairAccessibleCarPlaces();
    }

    public boolean hasCarPlaces() {
        return this.carPlaces;
    }

    public boolean hasWheelchairAccessibleCarPlaces() {
        return this.wheelchairAccessibleCarPlaces;
    }

    public boolean hasRealTimeData() {
        return this.availability != null;
    }

    public boolean hasSpacesAvailable(TraverseMode traverseMode, boolean wheelchairAccessible, boolean useAvailability) {
        switch (traverseMode) {
            case BICYCLE: {
                if (useAvailability && this.hasRealTimeDataForMode(TraverseMode.BICYCLE, false)) {
                    return this.availability.getBicycleSpaces() > 0;
                }
                return this.bicyclePlaces;
            }
            case CAR: {
                if (wheelchairAccessible) {
                    if (useAvailability && this.hasRealTimeDataForMode(TraverseMode.CAR, true)) {
                        return this.availability.getWheelchairAccessibleCarSpaces() > 0;
                    }
                    return this.wheelchairAccessibleCarPlaces;
                }
                if (useAvailability && this.hasRealTimeDataForMode(TraverseMode.CAR, false)) {
                    return this.availability.getCarSpaces() > 0;
                }
                return this.carPlaces;
            }
        }
        return false;
    }

    public boolean hasRealTimeDataForMode(TraverseMode traverseMode, boolean wheelchairAccessibleCarPlaces) {
        if (this.availability == null) {
            return false;
        }
        switch (traverseMode) {
            case BICYCLE: {
                return this.availability.getBicycleSpaces() != null;
            }
            case CAR: {
                Integer places = wheelchairAccessibleCarPlaces ? this.availability.getWheelchairAccessibleCarSpaces() : this.availability.getCarSpaces();
                return places != null;
            }
        }
        return false;
    }

    public void updateAvailability(VehicleParkingSpaces vehicleParkingSpaces) {
        this.availability = vehicleParkingSpaces;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.coordinate, this.detailsUrl, this.imageUrl, this.tags, this.openingHoursCalendar, this.note, this.state, this.bicyclePlaces, this.carPlaces, this.wheelchairAccessibleCarPlaces, this.capacity, this.entrances, this.vehicleParkingGroup});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VehicleParking that = (VehicleParking)o;
        return Objects.equals(this.coordinate, that.coordinate) && this.bicyclePlaces == that.bicyclePlaces && this.carPlaces == that.carPlaces && this.wheelchairAccessibleCarPlaces == that.wheelchairAccessibleCarPlaces && this.state == that.state && Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.detailsUrl, that.detailsUrl) && Objects.equals(this.imageUrl, that.imageUrl) && Objects.equals(this.tags, that.tags) && Objects.equals(this.openingHoursCalendar, that.openingHoursCalendar) && Objects.equals(this.note, that.note) && Objects.equals(this.capacity, that.capacity) && Objects.equals(this.entrances, that.entrances) && Objects.equals(this.vehicleParkingGroup, that.vehicleParkingGroup);
    }

    public String toString() {
        return ToStringBuilder.of(VehicleParking.class).addStr("name", this.name.toString()).addObj("coordinate", this.coordinate).toString();
    }

    private void addEntrance(VehicleParkingEntranceCreator creator) {
        VehicleParkingEntrance entrance = creator.updateValues(VehicleParkingEntrance.builder().vehicleParking(this)).build();
        this.entrances.add(entrance);
    }

    public static class VehicleParkingBuilder {
        private final List<VehicleParkingEntranceCreator> entranceCreators = new ArrayList<VehicleParkingEntranceCreator>();
        private Set<String> tags = Set.of();
        private OHCalendar openingHoursCalendar;
        private FeedScopedId id;
        private I18NString name;
        private WgsCoordinate coordinate;
        private String detailsUrl;
        private String imageUrl;
        private I18NString note;
        private VehicleParkingState state$value;
        private boolean state$set;
        private boolean bicyclePlaces;
        private boolean carPlaces;
        private boolean wheelchairAccessibleCarPlaces;
        private VehicleParkingSpaces capacity;
        private VehicleParkingSpaces availability;
        private VehicleParkingGroup vehicleParkingGroup;

        VehicleParkingBuilder() {
        }

        public VehicleParkingBuilder tags(Collection<String> tags) {
            this.tags = new HashSet<String>(tags);
            return this;
        }

        public VehicleParkingBuilder openingHoursCalendar(OHCalendar openingHoursCalendar) {
            this.openingHoursCalendar = openingHoursCalendar;
            return this;
        }

        public VehicleParkingBuilder entrances(Collection<VehicleParkingEntranceCreator> creators) {
            this.entranceCreators.addAll(creators);
            return this;
        }

        public VehicleParkingBuilder entrance(VehicleParkingEntranceCreator creator) {
            this.entranceCreators.add(creator);
            return this;
        }

        public VehicleParkingBuilder id(FeedScopedId id) {
            this.id = id;
            return this;
        }

        public VehicleParkingBuilder name(I18NString name) {
            this.name = name;
            return this;
        }

        public VehicleParkingBuilder coordinate(WgsCoordinate coordinate) {
            this.coordinate = coordinate;
            return this;
        }

        public VehicleParkingBuilder detailsUrl(String detailsUrl) {
            this.detailsUrl = detailsUrl;
            return this;
        }

        public VehicleParkingBuilder imageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }

        public VehicleParkingBuilder note(I18NString note) {
            this.note = note;
            return this;
        }

        public VehicleParkingBuilder state(VehicleParkingState state) {
            this.state$value = state;
            this.state$set = true;
            return this;
        }

        public VehicleParkingBuilder bicyclePlaces(boolean bicyclePlaces) {
            this.bicyclePlaces = bicyclePlaces;
            return this;
        }

        public VehicleParkingBuilder carPlaces(boolean carPlaces) {
            this.carPlaces = carPlaces;
            return this;
        }

        public VehicleParkingBuilder wheelchairAccessibleCarPlaces(boolean wheelchairAccessibleCarPlaces) {
            this.wheelchairAccessibleCarPlaces = wheelchairAccessibleCarPlaces;
            return this;
        }

        public VehicleParkingBuilder capacity(VehicleParkingSpaces capacity) {
            this.capacity = capacity;
            return this;
        }

        public VehicleParkingBuilder availability(VehicleParkingSpaces availability) {
            this.availability = availability;
            return this;
        }

        public VehicleParkingBuilder vehicleParkingGroup(VehicleParkingGroup vehicleParkingGroup) {
            this.vehicleParkingGroup = vehicleParkingGroup;
            return this;
        }

        public VehicleParking build() {
            VehicleParkingState state$value = this.state$value;
            if (!this.state$set) {
                state$value = VehicleParkingState.OPERATIONAL;
            }
            VehicleParking vehicleParking = new VehicleParking(this.id, this.name, this.coordinate, this.detailsUrl, this.imageUrl, this.tags, this.openingHoursCalendar, this.note, state$value, this.bicyclePlaces, this.carPlaces, this.wheelchairAccessibleCarPlaces, this.capacity, this.availability, this.vehicleParkingGroup);
            this.entranceCreators.forEach(vehicleParking::addEntrance);
            return vehicleParking;
        }
    }

    @FunctionalInterface
    public static interface VehicleParkingEntranceCreator {
        public VehicleParkingEntrance.VehicleParkingEntranceBuilder updateValues(VehicleParkingEntrance.VehicleParkingEntranceBuilder var1);
    }
}

