/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.stoptimes;

import com.google.common.collect.MinMaxPriorityQueue;
import gnu.trove.set.TIntSet;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Queue;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.model.StopTimesInPattern;
import org.opentripplanner.model.Timetable;
import org.opentripplanner.model.TripTimeOnDate;
import org.opentripplanner.routing.stoptimes.ArrivalDeparture;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.opentripplanner.transit.service.TransitService;
import org.opentripplanner.util.time.ServiceDateUtils;

public class StopTimesHelper {
    public static List<StopTimesInPattern> stopTimesForStop(TransitService transitService, StopLocation stop, Instant startTime, Duration timeRange, int numberOfDepartures, ArrivalDeparture arrivalDeparture, boolean includeCancelledTrips) {
        ArrayList<StopTimesInPattern> result = new ArrayList<StopTimesInPattern>();
        Collection<TripPattern> patterns = transitService.getPatternsForStop(stop, true);
        for (TripPattern pattern : patterns) {
            Queue<TripTimeOnDate> pq = StopTimesHelper.listTripTimeShortsForPatternAtStop(transitService, stop, pattern, startTime, timeRange, numberOfDepartures, arrivalDeparture, includeCancelledTrips, false);
            result.addAll(StopTimesHelper.getStopTimesInPattern(pattern, pq));
        }
        return result;
    }

    public static List<StopTimesInPattern> stopTimesForStop(TransitService transitService, StopLocation stop, LocalDate serviceDate, ArrivalDeparture arrivalDeparture, boolean includeCancellations) {
        ArrayList<StopTimesInPattern> ret = new ArrayList<StopTimesInPattern>();
        TIntSet servicesRunning = transitService.getServiceCodesRunningForDate(serviceDate);
        Instant midnight = ServiceDateUtils.asStartOfService(serviceDate, transitService.getTimeZone()).toInstant();
        for (TripPattern pattern : transitService.getPatternsForStop(stop, true)) {
            StopTimesInPattern stopTimes = new StopTimesInPattern(pattern);
            Timetable tt = transitService.getTimetableForTripPattern(pattern, serviceDate);
            List<StopLocation> stops = pattern.getStops();
            for (int i = 0; i < stops.size(); ++i) {
                StopLocation currStop = stops.get(i);
                if (currStop != stop || StopTimesHelper.skipByPickUpDropOff(pattern, arrivalDeparture, i) || StopTimesHelper.skipByStopCancellation(pattern, includeCancellations, i)) continue;
                for (TripTimes t : tt.getTripTimes()) {
                    if (StopTimesHelper.skipByTripCancellation(t, includeCancellations) || !servicesRunning.contains(t.getServiceCode())) continue;
                    stopTimes.times.add(new TripTimeOnDate(t, i, pattern, serviceDate, midnight));
                }
            }
            ret.add(stopTimes);
        }
        return ret;
    }

    public static List<TripTimeOnDate> stopTimesForPatternAtStop(TransitService transitService, StopLocation stop, TripPattern pattern, Instant startTime, Duration timeRange, int numberOfDepartures, ArrivalDeparture arrivalDeparture, boolean includeCancellations) {
        Queue<TripTimeOnDate> pq = StopTimesHelper.listTripTimeShortsForPatternAtStop(transitService, stop, pattern, startTime, timeRange, numberOfDepartures, arrivalDeparture, includeCancellations, true);
        return new ArrayList<TripTimeOnDate>(pq);
    }

    private static List<StopTimesInPattern> getStopTimesInPattern(TripPattern pattern, Queue<TripTimeOnDate> pq) {
        ArrayList<StopTimesInPattern> result = new ArrayList<StopTimesInPattern>();
        if (!pq.isEmpty()) {
            StopTimesInPattern stopTimes = new StopTimesInPattern(pattern);
            while (!pq.isEmpty()) {
                stopTimes.times.add(0, pq.poll());
            }
            result.add(stopTimes);
        }
        return result;
    }

    private static Queue<TripTimeOnDate> listTripTimeShortsForPatternAtStop(TransitService transitService, StopLocation stop, TripPattern pattern, Instant startTime, Duration timeRange, int numberOfDepartures, ArrivalDeparture arrivalDeparture, boolean includeCancellations, boolean includeReplaced) {
        ZoneId zoneId = transitService.getTimeZone();
        LocalDate startDate = startTime.atZone(zoneId).toLocalDate().minusDays(1L);
        LocalDate endDate = startTime.plus(timeRange).atZone(zoneId).toLocalDate();
        List<LocalDate> serviceDates = startDate.datesUntil(endDate.plusDays(1L)).toList();
        MinMaxPriorityQueue pq = MinMaxPriorityQueue.orderedBy(Comparator.comparing(tts -> tts.getServiceDayMidnight() + (long)tts.getRealtimeDeparture())).maximumSize(numberOfDepartures).create();
        int timeRangeSeconds = (int)timeRange.toSeconds();
        for (LocalDate serviceDate : serviceDates) {
            Timetable timetable = transitService.getTimetableForTripPattern(pattern, serviceDate);
            ZonedDateTime midnight = ServiceDateUtils.asStartOfService(serviceDate, zoneId);
            int secondsSinceMidnight = ServiceDateUtils.secondsSinceStartOfService(midnight, ZonedDateTime.ofInstant(startTime, zoneId));
            TIntSet servicesRunning = transitService.getServiceCodesRunningForDate(serviceDate);
            List<StopLocation> stops = pattern.getStops();
            for (int stopIndex = 0; stopIndex < stops.size(); ++stopIndex) {
                StopLocation currStop = stops.get(stopIndex);
                if (currStop != stop || StopTimesHelper.skipByPickUpDropOff(pattern, arrivalDeparture, stopIndex) || StopTimesHelper.skipByStopCancellation(pattern, includeCancellations, stopIndex)) continue;
                for (TripTimes tripTimes : timetable.getTripTimes()) {
                    boolean arrivalTimeInRange;
                    if (!servicesRunning.contains(tripTimes.getServiceCode()) || StopTimesHelper.skipByTripCancellation(tripTimes, includeCancellations) || !includeReplaced && StopTimesHelper.isReplacedByAnotherPattern(tripTimes.getTrip(), serviceDate, pattern, transitService)) continue;
                    boolean departureTimeInRange = tripTimes.getDepartureTime(stopIndex) >= secondsSinceMidnight && tripTimes.getDepartureTime(stopIndex) <= secondsSinceMidnight + timeRangeSeconds;
                    boolean bl = arrivalTimeInRange = tripTimes.getArrivalTime(stopIndex) >= secondsSinceMidnight && tripTimes.getArrivalTime(stopIndex) <= secondsSinceMidnight + timeRangeSeconds;
                    if ((arrivalDeparture == ArrivalDeparture.ARRIVALS || !departureTimeInRange) && (arrivalDeparture == ArrivalDeparture.DEPARTURES || !arrivalTimeInRange)) continue;
                    pq.add((Object)new TripTimeOnDate(tripTimes, stopIndex, pattern, serviceDate, midnight.toInstant()));
                }
            }
        }
        return pq;
    }

    private static boolean isReplacedByAnotherPattern(Trip trip, LocalDate serviceDate, TripPattern pattern, TransitService transitService) {
        TripPattern replacement = transitService.getRealtimeAddedTripPattern(trip.getId(), serviceDate);
        return replacement != null && !replacement.equals(pattern);
    }

    public static boolean skipByTripCancellation(TripTimes tripTimes, boolean includeCancellations) {
        return (tripTimes.isCanceled() || tripTimes.getTrip().getNetexAlteration().isCanceledOrReplaced()) && !includeCancellations;
    }

    private static boolean skipByPickUpDropOff(TripPattern pattern, ArrivalDeparture arrivalDeparture, int stopIndex) {
        boolean noPickup = pattern.getBoardType(stopIndex).is(PickDrop.NONE);
        boolean noDropoff = pattern.getAlightType(stopIndex).is(PickDrop.NONE);
        if (noPickup && noDropoff) {
            return true;
        }
        if (noPickup && arrivalDeparture == ArrivalDeparture.DEPARTURES) {
            return true;
        }
        return noDropoff && arrivalDeparture == ArrivalDeparture.ARRIVALS;
    }

    private static boolean skipByStopCancellation(TripPattern pattern, boolean includeCancelledTrips, int stopIndex) {
        boolean pickupCancelled = pattern.getBoardType(stopIndex).is(PickDrop.CANCELLED);
        boolean dropOffCancelled = pattern.getAlightType(stopIndex).is(PickDrop.CANCELLED);
        return (pickupCancelled || dropOffCancelled) && !includeCancelledTrips;
    }
}

