/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.services.notes;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opentripplanner.model.StreetNote;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.services.notes.MatcherAndStreetNote;
import org.opentripplanner.routing.services.notes.NoteMatcher;
import org.opentripplanner.routing.services.notes.StaticStreetNotesSource;
import org.opentripplanner.routing.services.notes.StreetNotesSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreetNotesService
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(StreetNotesService.class);
    public static final NoteMatcher WHEELCHAIR_MATCHER = new NoteMatcher(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean matches(State state) {
            return state.getRequest().wheelchair();
        }
    };
    public static final NoteMatcher DRIVING_MATCHER = new NoteMatcher(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean matches(State state) {
            return state.getBackMode().isDriving();
        }
    };
    public static final NoteMatcher BICYCLE_MATCHER = new NoteMatcher(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean matches(State state) {
            return state.getBackMode() == TraverseMode.BICYCLE;
        }
    };
    public static final NoteMatcher ALWAYS_MATCHER = new NoteMatcher(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean matches(State state) {
            return true;
        }
    };
    private final List<StreetNotesSource> sources = new ArrayList<StreetNotesSource>();
    private final StaticStreetNotesSource staticNotesSource = new StaticStreetNotesSource();

    public StreetNotesService() {
        this.sources.add(this.staticNotesSource);
    }

    public void addNotesSource(StreetNotesSource source) {
        this.sources.add(source);
    }

    public Set<StreetNote> getNotes(State state) {
        Edge edge = state.getBackEdge();
        HashSet<MatcherAndStreetNote> maas = new HashSet<MatcherAndStreetNote>();
        for (StreetNotesSource source : this.sources) {
            Set<MatcherAndStreetNote> maas2 = source.getNotes(edge);
            if (maas2 == null) continue;
            maas.addAll(maas2);
        }
        if (maas == null || maas.isEmpty()) {
            return null;
        }
        HashSet<StreetNote> notes = new HashSet<StreetNote>(maas.size());
        for (MatcherAndStreetNote maa : maas) {
            if (!maa.getMatcher().matches(state)) continue;
            notes.add(maa.getNote());
        }
        if (notes.isEmpty()) {
            return null;
        }
        return notes;
    }

    public void addStaticNote(Edge edge, StreetNote note, NoteMatcher matcher) {
        this.staticNotesSource.addNote(edge, note, matcher);
    }

    public void removeStaticNotes(Edge edge) {
        this.staticNotesSource.removeNotes(edge);
    }
}

