/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.common.geometry.HashGridSpatialIndex;
import org.opentripplanner.common.geometry.SphericalDistanceLibrary;
import org.opentripplanner.common.model.P2;
import org.opentripplanner.graph_builder.linking.DisposableEdgeCollection;
import org.opentripplanner.graph_builder.linking.LinkingDirection;
import org.opentripplanner.graph_builder.linking.VertexLinker;
import org.opentripplanner.model.GenericLocation;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.routing.core.TraverseModeSet;
import org.opentripplanner.routing.edgetype.StreetEdge;
import org.opentripplanner.routing.edgetype.TemporaryFreeEdge;
import org.opentripplanner.routing.edgetype.TemporaryPartialStreetEdge;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.location.TemporaryStreetLocation;
import org.opentripplanner.routing.vertextype.StreetVertex;
import org.opentripplanner.routing.vertextype.TransitStopVertex;
import org.opentripplanner.transit.model.basic.I18NString;
import org.opentripplanner.transit.model.basic.LocalizedString;
import org.opentripplanner.transit.model.basic.NonLocalizedString;
import org.opentripplanner.transit.model.basic.WgsCoordinate;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.service.StopModel;
import org.opentripplanner.util.geometry.GeometryUtils;
import org.opentripplanner.util.logging.ProgressTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreetVertexIndex {
    private static final Logger LOG = LoggerFactory.getLogger(StreetVertexIndex.class);
    private final StopModel stopModel;
    private final VertexLinker vertexLinker;
    private final Map<FeedScopedId, TransitStopVertex> transitStopVertices;
    private final HashGridSpatialIndex<Edge> edgeTree;
    private final HashGridSpatialIndex<Vertex> verticesTree;

    public StreetVertexIndex(Graph graph, StopModel stopModel) {
        this.stopModel = stopModel;
        this.edgeTree = new HashGridSpatialIndex();
        this.verticesTree = new HashGridSpatialIndex();
        this.vertexLinker = new VertexLinker(graph, stopModel);
        this.transitStopVertices = StreetVertexIndex.toImmutableMap(graph.getVerticesOfType(TransitStopVertex.class));
        this.postSetup(graph.getVertices());
    }

    public static TemporaryStreetLocation createTemporaryStreetLocationForTest(String label, I18NString name, Iterable<StreetEdge> edges, Coordinate nearestPoint, boolean endVertex, DisposableEdgeCollection tempEdges) {
        boolean wheelchairAccessible = false;
        TemporaryStreetLocation location = new TemporaryStreetLocation(label, nearestPoint, name, endVertex);
        for (StreetEdge street : edges) {
            Vertex edgeLocation;
            Vertex fromv = street.getFromVertex();
            Vertex tov = street.getToVertex();
            wheelchairAccessible |= street.isWheelchairAccessible();
            if (SphericalDistanceLibrary.distance(nearestPoint, fromv.getCoordinate()) < 1.0) {
                edgeLocation = fromv;
                if (endVertex) {
                    tempEdges.addEdge(new TemporaryFreeEdge(edgeLocation, location));
                    continue;
                }
                tempEdges.addEdge(new TemporaryFreeEdge(location, edgeLocation));
                continue;
            }
            if (SphericalDistanceLibrary.distance(nearestPoint, tov.getCoordinate()) < 1.0) {
                edgeLocation = tov;
                if (endVertex) {
                    tempEdges.addEdge(new TemporaryFreeEdge(edgeLocation, location));
                    continue;
                }
                tempEdges.addEdge(new TemporaryFreeEdge(location, edgeLocation));
                continue;
            }
            StreetVertexIndex.createHalfLocationForTest(location, name, nearestPoint, street, endVertex, tempEdges);
        }
        location.setWheelchairAccessible(wheelchairAccessible);
        return location;
    }

    public VertexLinker getVertexLinker() {
        return this.vertexLinker;
    }

    public TransitStopVertex findTransitStopVertices(FeedScopedId stopId) {
        return this.transitStopVertices.get(stopId);
    }

    public List<Vertex> getVerticesForEnvelope(Envelope envelope) {
        List<Vertex> vertices = this.verticesTree.query(envelope);
        vertices.removeIf(v -> !envelope.contains(new Coordinate(v.getLon(), v.getLat())));
        return vertices;
    }

    public Collection<Edge> getEdgesForEnvelope(Envelope envelope) {
        List<Edge> edges = this.edgeTree.query(envelope);
        Iterator<Edge> ie = edges.iterator();
        while (ie.hasNext()) {
            Edge e = ie.next();
            if (e.getToVertex() == null || e.getFromVertex() == null) {
                ie.remove();
                continue;
            }
            Envelope eenv = StreetVertexIndex.edgeGeometryOrStraightLine(e).getEnvelopeInternal();
            if (envelope.intersects(eenv)) continue;
            ie.remove();
        }
        return edges;
    }

    public Set<Vertex> getVerticesForLocation(GenericLocation location, StreetMode streetMode, boolean endVertex, Set<DisposableEdgeCollection> tempEdges) {
        Set<Vertex> transitStopVertices;
        TraverseMode nonTransitMode = this.getTraverseModeForLinker(streetMode, endVertex);
        if (nonTransitMode.isDriving()) {
            WgsCoordinate coordinate;
            if (location.stopId != null && location.getCoordinate() == null && (coordinate = this.stopModel.getCoordinateById(location.stopId)) != null) {
                location = new GenericLocation(location.label, location.stopId, coordinate.latitude(), coordinate.longitude());
            }
        } else if (location.stopId != null && (transitStopVertices = this.getStopVerticesById(location.stopId)) != null && !transitStopVertices.isEmpty()) {
            return transitStopVertices;
        }
        if (location.getCoordinate() != null) {
            return Set.of(this.createVertexFromLocation(location, streetMode, endVertex, tempEdges));
        }
        return null;
    }

    public String toString() {
        return this.getClass().getName() + " -- edgeTree: " + this.edgeTree.toString() + " -- verticesTree: " + this.verticesTree.toString();
    }

    public Vertex getVertexForLocationForTest(GenericLocation location, StreetMode streetMode, boolean endVertex, Set<DisposableEdgeCollection> tempEdges) {
        Coordinate coordinate = location.getCoordinate();
        if (coordinate != null) {
            return this.createVertexFromLocation(location, streetMode, endVertex, tempEdges);
        }
        return null;
    }

    private Set<Vertex> getStopVerticesById(FeedScopedId id) {
        return this.stopModel.findStopOrChildStops(id).stream().filter(RegularStop.class::isInstance).map(RegularStop.class::cast).map(it -> this.transitStopVertices.get(it.getId())).collect(Collectors.toSet());
    }

    private static void createHalfLocationForTest(TemporaryStreetLocation base, I18NString name, Coordinate nearestPoint, StreetEdge street, boolean endVertex, DisposableEdgeCollection tempEdges) {
        StreetVertex tov = (StreetVertex)street.getToVertex();
        StreetVertex fromv = (StreetVertex)street.getFromVertex();
        LineString geometry = street.getGeometry();
        P2<LineString> geometries = StreetVertexIndex.getGeometry(street, nearestPoint);
        double totalGeomLength = geometry.getLength();
        double lengthRatioIn = ((LineString)geometries.first).getLength() / totalGeomLength;
        double lengthIn = street.getDistanceMeters() * lengthRatioIn;
        double lengthOut = street.getDistanceMeters() * (1.0 - lengthRatioIn);
        if (endVertex) {
            TemporaryPartialStreetEdge temporaryPartialStreetEdge = new TemporaryPartialStreetEdge(street, fromv, (StreetVertex)base, (LineString)geometries.first, name, lengthIn);
            temporaryPartialStreetEdge.setMotorVehicleNoThruTraffic(street.isMotorVehicleNoThruTraffic());
            temporaryPartialStreetEdge.setBicycleNoThruTraffic(street.isBicycleNoThruTraffic());
            temporaryPartialStreetEdge.setWalkNoThruTraffic(street.isWalkNoThruTraffic());
            temporaryPartialStreetEdge.setStreetClass(street.getStreetClass());
            tempEdges.addEdge(temporaryPartialStreetEdge);
        } else {
            TemporaryPartialStreetEdge temporaryPartialStreetEdge = new TemporaryPartialStreetEdge(street, (StreetVertex)base, tov, (LineString)geometries.second, name, lengthOut);
            temporaryPartialStreetEdge.setStreetClass(street.getStreetClass());
            temporaryPartialStreetEdge.setMotorVehicleNoThruTraffic(street.isMotorVehicleNoThruTraffic());
            temporaryPartialStreetEdge.setBicycleNoThruTraffic(street.isBicycleNoThruTraffic());
            temporaryPartialStreetEdge.setWalkNoThruTraffic(street.isWalkNoThruTraffic());
            tempEdges.addEdge(temporaryPartialStreetEdge);
        }
    }

    private static P2<LineString> getGeometry(StreetEdge e, Coordinate nearestPoint) {
        LineString geometry = e.getGeometry();
        return GeometryUtils.splitGeometryAtPoint((Geometry)geometry, nearestPoint);
    }

    private static LineString edgeGeometryOrStraightLine(Edge e) {
        LineString geometry = e.getGeometry();
        if (geometry == null) {
            Coordinate[] coordinates = new Coordinate[]{e.getFromVertex().getCoordinate(), e.getToVertex().getCoordinate()};
            geometry = GeometryUtils.getGeometryFactory().createLineString(coordinates);
        }
        return geometry;
    }

    private Vertex createVertexFromLocation(GenericLocation location, StreetMode streetMode, boolean endVertex, Set<DisposableEdgeCollection> tempEdges) {
        if (endVertex) {
            LOG.debug("Finding end vertex for {}", (Object)location);
        } else {
            LOG.debug("Finding start vertex for {}", (Object)location);
        }
        Serializable name = location.label == null || location.label.isEmpty() ? (endVertex ? new LocalizedString("destination") : new LocalizedString("origin")) : new NonLocalizedString(location.label);
        TemporaryStreetLocation temporaryStreetLocation = new TemporaryStreetLocation(UUID.randomUUID().toString(), location.getCoordinate(), (I18NString)((Object)name), endVertex);
        TraverseMode nonTransitMode = this.getTraverseModeForLinker(streetMode, endVertex);
        tempEdges.add(this.vertexLinker.linkVertexForRequest(temporaryStreetLocation, new TraverseModeSet(nonTransitMode), endVertex ? LinkingDirection.OUTGOING : LinkingDirection.INCOMING, endVertex ? (vertex, streetVertex) -> List.of(new TemporaryFreeEdge((Vertex)streetVertex, (TemporaryStreetLocation)vertex)) : (vertex, streetVertex) -> List.of(new TemporaryFreeEdge((TemporaryStreetLocation)vertex, (Vertex)streetVertex))));
        if (temporaryStreetLocation.getIncoming().isEmpty() && temporaryStreetLocation.getOutgoing().isEmpty()) {
            LOG.warn("Couldn't link {}", (Object)location);
        }
        temporaryStreetLocation.setWheelchairAccessible(true);
        return temporaryStreetLocation;
    }

    private TraverseMode getTraverseModeForLinker(StreetMode streetMode, boolean endVertex) {
        boolean onlyCarAvailable;
        TraverseMode nonTransitMode = TraverseMode.WALK;
        boolean parkAndRideDepart = streetMode == StreetMode.CAR_TO_PARK && !endVertex;
        boolean bl = onlyCarAvailable = streetMode == StreetMode.CAR;
        if (onlyCarAvailable || parkAndRideDepart) {
            nonTransitMode = TraverseMode.CAR;
        }
        return nonTransitMode;
    }

    private void postSetup(Collection<Vertex> vertices) {
        ProgressTracker progress = ProgressTracker.track("Index street vertex", 1000, vertices.size());
        LOG.info(progress.startMessage());
        for (Vertex gv : vertices) {
            for (Edge e : gv.getOutgoing()) {
                LineString geometry = StreetVertexIndex.edgeGeometryOrStraightLine(e);
                this.edgeTree.insert(geometry, (Object)e);
            }
            Envelope env = new Envelope(gv.getCoordinate());
            this.verticesTree.insert(env, (Object)gv);
            progress.step(m -> LOG.info(m));
        }
        LOG.info(progress.completeMessage());
    }

    private static Map<FeedScopedId, TransitStopVertex> toImmutableMap(Collection<TransitStopVertex> vertices) {
        HashMap<FeedScopedId, TransitStopVertex> map = new HashMap<FeedScopedId, TransitStopVertex>();
        for (TransitStopVertex it : vertices) {
            map.put(it.getStop().getId(), it);
        }
        return Map.copyOf(map);
    }
}

