/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.edgetype;

import java.util.Set;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.routing.api.request.request.VehicleParkingRequest;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.routing.core.StateEditor;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.vehicle_parking.VehicleParking;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingEntrance;
import org.opentripplanner.routing.vertextype.StreetVertex;
import org.opentripplanner.routing.vertextype.VehicleParkingEntranceVertex;
import org.opentripplanner.transit.model.basic.I18NString;

public class StreetVehicleParkingLink
extends Edge {
    private final VehicleParkingEntranceVertex vehicleParkingEntranceVertex;

    public StreetVehicleParkingLink(StreetVertex fromv, VehicleParkingEntranceVertex tov) {
        super(fromv, tov);
        this.vehicleParkingEntranceVertex = tov;
    }

    public StreetVehicleParkingLink(VehicleParkingEntranceVertex fromv, StreetVertex tov) {
        super(fromv, tov);
        this.vehicleParkingEntranceVertex = fromv;
    }

    @Override
    public String toString() {
        return "StreetVehicleParkingLink(" + this.fromv + " -> " + this.tov + ")";
    }

    @Override
    public State traverse(State s0) {
        VehicleParkingRequest parkingRequest;
        if (s0.getBackEdge() instanceof StreetVehicleParkingLink) {
            return null;
        }
        VehicleParkingEntrance entrance = this.vehicleParkingEntranceVertex.getParkingEntrance();
        if (s0.getNonTransitMode() == TraverseMode.CAR ? !entrance.isCarAccessible() : !entrance.isWalkAccessible()) {
            return null;
        }
        VehicleParking vehicleParking = this.vehicleParkingEntranceVertex.getVehicleParking();
        if (this.hasMissingRequiredTags(vehicleParking, (parkingRequest = s0.getRequest().parking()).requiredTags()) || this.hasBannedTags(vehicleParking, parkingRequest.bannedTags())) {
            return null;
        }
        StateEditor s1 = s0.edit(this);
        s1.incrementWeight(1.0);
        s1.setBackMode(null);
        return s1.makeState();
    }

    @Override
    public I18NString getName() {
        return this.vehicleParkingEntranceVertex.getName();
    }

    @Override
    public LineString getGeometry() {
        return null;
    }

    @Override
    public double getDistanceMeters() {
        return 0.0;
    }

    private boolean hasBannedTags(VehicleParking vehicleParking, Set<String> bannedTags) {
        if (bannedTags.isEmpty()) {
            return false;
        }
        return vehicleParking.getTags().stream().anyMatch(bannedTags::contains);
    }

    private boolean hasMissingRequiredTags(VehicleParking vehicleParking, Set<String> requiredTags) {
        if (requiredTags.isEmpty()) {
            return false;
        }
        return !vehicleParking.getTags().containsAll(requiredTags);
    }
}

