/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.edgetype;

import java.io.Serializable;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.impl.PackedCoordinateSequence;
import org.opentripplanner.common.geometry.CompactElevationProfile;
import org.opentripplanner.routing.edgetype.StreetEdge;
import org.opentripplanner.routing.edgetype.StreetTraversalPermission;
import org.opentripplanner.routing.util.ElevationUtils;
import org.opentripplanner.routing.util.SlopeCosts;
import org.opentripplanner.util.lang.ToStringBuilder;

public class StreetElevationExtension
implements Serializable {
    private final double distanceMeters;
    private final byte[] compactedElevationProfile;
    private final PackedCoordinateSequence packedElevationProfile;
    private final double effectiveBicycleSafetyDistance;
    private final double effectiveBikeDistance;
    private final double effectiveBikeDistanceForWorkCost;
    private final double effectiveWalkDistance;
    private final double effectiveWalkSafetyDistance;
    private final double distanceWithElevation;
    private final float maxSlope;
    private final boolean flattened;

    private StreetElevationExtension(double distanceMeters, boolean computed, PackedCoordinateSequence packedElevationProfile, float effectiveBicycleSafetyFactor, double effectiveBikeDistanceFactor, double effectiveBikeWorkFactor, double effectiveWalkDistanceFactor, double effectiveWalkSafetyFactor, double lengthMultiplier, float maxSlope, boolean flattened) {
        this.distanceMeters = distanceMeters;
        this.effectiveBicycleSafetyDistance = (double)effectiveBicycleSafetyFactor * distanceMeters;
        this.effectiveBikeDistance = effectiveBikeDistanceFactor * distanceMeters;
        this.effectiveBikeDistanceForWorkCost = effectiveBikeWorkFactor * distanceMeters;
        this.effectiveWalkDistance = effectiveWalkDistanceFactor * distanceMeters;
        this.effectiveWalkSafetyDistance = effectiveWalkSafetyFactor * distanceMeters;
        this.distanceWithElevation = lengthMultiplier * distanceMeters;
        this.maxSlope = maxSlope;
        this.flattened = flattened;
        if (computed) {
            this.compactedElevationProfile = null;
            this.packedElevationProfile = packedElevationProfile;
        } else {
            this.compactedElevationProfile = CompactElevationProfile.compactElevationProfileWithRegularSamples((CoordinateSequence)packedElevationProfile);
            this.packedElevationProfile = null;
        }
    }

    public static void addToEdge(StreetEdge streetEdge, PackedCoordinateSequence elevationProfile, boolean computed) {
        if (elevationProfile != null && elevationProfile.size() >= 2 && (!streetEdge.isSlopeOverride() || computed)) {
            StreetElevationExtension extension = StreetElevationExtension.calculateForEdge(streetEdge, elevationProfile, computed);
            streetEdge.setElevationExtension(extension);
        }
    }

    public PackedCoordinateSequence getElevationProfile() {
        if (this.compactedElevationProfile != null) {
            return CompactElevationProfile.uncompactElevationProfileWithRegularSamples(this.compactedElevationProfile, this.distanceMeters);
        }
        return this.packedElevationProfile;
    }

    public double getEffectiveBicycleSafetyDistance() {
        return this.effectiveBicycleSafetyDistance;
    }

    public double getEffectiveBikeDistance() {
        return this.effectiveBikeDistance;
    }

    public double getEffectiveBikeDistanceForWorkCost() {
        return this.effectiveBikeDistanceForWorkCost;
    }

    public double getEffectiveWalkDistance() {
        return this.effectiveWalkDistance;
    }

    public double getEffectiveWalkSafetyDistance() {
        return this.effectiveWalkSafetyDistance;
    }

    public double getDistanceWithElevation() {
        return this.distanceWithElevation;
    }

    public float getMaxSlope() {
        return this.maxSlope;
    }

    public boolean isFlattened() {
        return this.flattened;
    }

    public String toString() {
        return ToStringBuilder.of(StreetElevationExtension.class).addBoolIfTrue("flattened", this.flattened).addNum("distanceMeters", this.distanceMeters).addNum("effectiveBicycleSafetyFactor", this.effectiveBicycleSafetyDistance).addNum("effectiveBikeDistance", this.effectiveBikeDistance).addNum("effectiveBikeDistanceForWorkCost", this.effectiveBikeDistanceForWorkCost).addNum("effectiveWalkDistance", this.effectiveWalkDistance).addNum("maxSlope", Float.valueOf(this.maxSlope)).toString();
    }

    private static StreetElevationExtension calculateForEdge(StreetEdge streetEdge, PackedCoordinateSequence elevationProfile, boolean computed) {
        boolean slopeLimit = streetEdge.getPermission().allows(StreetTraversalPermission.CAR);
        SlopeCosts costs = ElevationUtils.getSlopeCosts((CoordinateSequence)elevationProfile, slopeLimit);
        double effectiveBikeDistanceFactor = costs.slopeSpeedFactor;
        double effectiveBikeWorkFactor = costs.slopeWorkFactor;
        double effectiveWalkDistanceFactor = costs.effectiveWalkFactor;
        float maxSlope = (float)costs.maxSlope;
        boolean flattened = costs.flattened;
        float effectiveBicycleSafetyFactor = (float)((double)streetEdge.getBicycleSafetyFactor() * costs.lengthMultiplier + costs.slopeSafetyCost / streetEdge.getDistanceMeters());
        if (Double.isInfinite(effectiveBicycleSafetyFactor) || Double.isNaN(effectiveBicycleSafetyFactor)) {
            throw new IllegalStateException("Elevation updated bicycleSafetyFactor is " + effectiveBicycleSafetyFactor);
        }
        float effectiveWalkSafetyFactor = (float)((double)streetEdge.getWalkSafetyFactor() * effectiveWalkDistanceFactor);
        if (Double.isInfinite(effectiveWalkSafetyFactor) || Double.isNaN(effectiveWalkSafetyFactor)) {
            throw new IllegalStateException("Elevation updated walkSafetyFactor is " + effectiveWalkSafetyFactor);
        }
        if (streetEdge.isStairs()) {
            effectiveBikeDistanceFactor = 1.0;
            effectiveWalkDistanceFactor = 1.0;
        }
        return new StreetElevationExtension(streetEdge.getDistanceMeters(), computed, elevationProfile, effectiveBicycleSafetyFactor, effectiveBikeDistanceFactor, effectiveBikeWorkFactor, effectiveWalkDistanceFactor, effectiveWalkSafetyFactor, costs.lengthMultiplier, maxSlope, flattened);
    }
}

