/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.edgetype;

import org.opentripplanner.routing.core.CarPickupState;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.routing.core.StateEditor;

public interface CarPickupableEdge {
    default public boolean canPickupAndDrive(State state) {
        return state.getRequest().mode().includesPickup() && state.getCarPickupState() == (state.getRequest().arriveBy() ? CarPickupState.WALK_FROM_DROP_OFF : CarPickupState.WALK_TO_PICKUP);
    }

    default public boolean canDropOffAfterDriving(State state) {
        return state.getRequest().mode().includesPickup() && state.getCarPickupState() == CarPickupState.IN_CAR;
    }

    default public void dropOffAfterDriving(State state, StateEditor editor) {
        editor.setCarPickupState(state.getRequest().arriveBy() ? CarPickupState.WALK_TO_PICKUP : CarPickupState.WALK_FROM_DROP_OFF);
        editor.incrementTimeInSeconds(state.getPreferences().car().pickupTime());
        editor.incrementWeight(state.getPreferences().car().pickupCost());
    }

    default public void driveAfterPickup(State state, StateEditor editor) {
        editor.setCarPickupState(CarPickupState.IN_CAR);
        editor.incrementTimeInSeconds(state.getPreferences().car().pickupTime());
        editor.incrementWeight(state.getPreferences().car().pickupCost());
    }
}

