/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.edgetype;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.distance.DistanceOp;
import org.opentripplanner.common.geometry.SphericalDistanceLibrary;
import org.opentripplanner.routing.edgetype.AreaEdge;
import org.opentripplanner.routing.edgetype.NamedArea;
import org.opentripplanner.routing.vertextype.IntersectionVertex;
import org.opentripplanner.util.geometry.GeometryUtils;

public class AreaEdgeList
implements Serializable {
    public final HashSet<IntersectionVertex> visibilityVertices = new HashSet();
    private final Polygon originalEdges;
    public final Set<String> references;
    private final List<NamedArea> areas = new ArrayList<NamedArea>();

    public AreaEdgeList(Polygon originalEdges, Set<String> references) {
        this.originalEdges = originalEdges;
        this.references = references;
    }

    public void addVertex(IntersectionVertex newVertex) {
        GeometryFactory geometryFactory = GeometryUtils.getGeometryFactory();
        Geometry polygon = this.originalEdges.union(this.originalEdges.getBoundary()).buffer(1.0E-6);
        Coordinate[] nearestPoints = DistanceOp.nearestPoints((Geometry)polygon, (Geometry)geometryFactory.createPoint(newVertex.getCoordinate()));
        int added = 0;
        for (IntersectionVertex v : this.visibilityVertices) {
            LineString newGeometry = geometryFactory.createLineString(new Coordinate[]{nearestPoints[0], v.getCoordinate()});
            if (!polygon.contains((Geometry)newGeometry)) continue;
            this.createSegments(newVertex, v, this.areas);
            ++added;
        }
        if (added == 0) {
            for (IntersectionVertex v : this.visibilityVertices) {
                this.createSegments(newVertex, v, this.areas);
            }
        }
        this.visibilityVertices.add(newVertex);
    }

    public void addArea(NamedArea namedArea) {
        this.areas.add(namedArea);
    }

    public List<NamedArea> getAreas() {
        return this.areas;
    }

    public Geometry getGeometry() {
        return this.originalEdges;
    }

    private void createSegments(IntersectionVertex from, IntersectionVertex to, List<NamedArea> areas) {
        GeometryFactory geometryFactory = GeometryUtils.getGeometryFactory();
        LineString line = geometryFactory.createLineString(new Coordinate[]{from.getCoordinate(), to.getCoordinate()});
        ArrayList<NamedArea> intersects = new ArrayList<NamedArea>();
        for (NamedArea area : areas) {
            Geometry polygon = area.getPolygon();
            Geometry intersection = polygon.intersection((Geometry)line);
            if (!(intersection.getLength() > 1.0E-6)) continue;
            intersects.add(area);
        }
        if (!intersects.isEmpty()) {
            NamedArea area = (NamedArea)intersects.get(0);
            double length = SphericalDistanceLibrary.distance(to.getCoordinate(), from.getCoordinate());
            AreaEdge forward = new AreaEdge(from, to, line, area.getName(), length, area.getPermission(), false, this);
            forward.setStreetClass(area.getStreetClass());
            AreaEdge backward = new AreaEdge(to, from, line.reverse(), area.getName(), length, area.getPermission(), true, this);
            backward.setStreetClass(area.getStreetClass());
        }
    }
}

