/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.core.intersection_model;

import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.routing.core.intersection_model.DrivingDirection;
import org.opentripplanner.routing.core.intersection_model.IntersectionTraversalModel;
import org.opentripplanner.routing.core.intersection_model.NorwayIntersectionTraversalCalculator;
import org.opentripplanner.routing.core.intersection_model.SimpleIntersectionTraversalCalculator;
import org.opentripplanner.routing.edgetype.StreetEdge;
import org.opentripplanner.routing.vertextype.IntersectionVertex;

public interface IntersectionTraversalCalculator {
    public static final IntersectionTraversalCalculator DEFAULT = IntersectionTraversalCalculator.create(IntersectionTraversalModel.SIMPLE, DrivingDirection.RIGHT);

    public double computeTraversalDuration(IntersectionVertex var1, StreetEdge var2, StreetEdge var3, TraverseMode var4, float var5, float var6);

    public static IntersectionTraversalCalculator create(IntersectionTraversalModel intersectionTraversalModel, DrivingDirection drivingDirection) {
        return switch (intersectionTraversalModel) {
            default -> throw new IncompatibleClassChangeError();
            case IntersectionTraversalModel.NORWAY -> new NorwayIntersectionTraversalCalculator(drivingDirection);
            case IntersectionTraversalModel.SIMPLE -> new SimpleIntersectionTraversalCalculator(drivingDirection);
        };
    }
}

