/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.core;

import java.util.EnumSet;

public enum TraverseMode {
    WALK,
    BICYCLE,
    SCOOTER,
    CAR,
    FLEX;

    private static final EnumSet<TraverseMode> STREET_MODES;

    public boolean isOnStreetNonTransit() {
        return STREET_MODES.contains((Object)this);
    }

    public boolean isDriving() {
        return this == CAR;
    }

    public boolean isCycling() {
        return this == BICYCLE || this == SCOOTER;
    }

    public boolean isWalking() {
        return this == WALK;
    }

    static {
        STREET_MODES = EnumSet.of(WALK, BICYCLE, SCOOTER, CAR);
    }
}

