/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.core;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.opentripplanner.graph_builder.linking.DisposableEdgeCollection;
import org.opentripplanner.graph_builder.linking.SameEdgeAdjuster;
import org.opentripplanner.model.GenericLocation;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.api.response.InputField;
import org.opentripplanner.routing.api.response.RoutingError;
import org.opentripplanner.routing.api.response.RoutingErrorCode;
import org.opentripplanner.routing.error.RoutingValidationException;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.impl.StreetVertexIndex;
import org.opentripplanner.routing.vertextype.TransitStopVertex;
import org.opentripplanner.util.geometry.GeometryUtils;

public class TemporaryVerticesContainer
implements AutoCloseable {
    private final Graph graph;
    private final RouteRequest opt;
    private final Set<DisposableEdgeCollection> tempEdges = new HashSet<DisposableEdgeCollection>();
    private final Set<Vertex> fromVertices;
    private final Set<Vertex> toVertices;

    public TemporaryVerticesContainer(Graph graph, RouteRequest opt, StreetMode accessMode, StreetMode egressMode) {
        this.graph = graph;
        StreetVertexIndex index = this.graph.getStreetIndex();
        this.opt = opt;
        this.fromVertices = index.getVerticesForLocation(opt.from(), accessMode, false, this.tempEdges);
        this.toVertices = index.getVerticesForLocation(opt.to(), egressMode, true, this.tempEdges);
        this.checkIfVerticesFound(opt.arriveBy());
        if (this.fromVertices != null && this.toVertices != null) {
            for (Vertex fromVertex : this.fromVertices) {
                for (Vertex toVertex : this.toVertices) {
                    this.tempEdges.add(SameEdgeAdjuster.adjust(fromVertex, toVertex, graph));
                }
            }
        }
    }

    @Override
    public void close() {
        this.tempEdges.forEach(DisposableEdgeCollection::disposeEdges);
    }

    public Set<Vertex> getFromVertices() {
        return this.fromVertices;
    }

    public Set<Vertex> getToVertices() {
        return this.toVertices;
    }

    private void checkIfVerticesFound(boolean arriveBy) {
        Set<Vertex> to;
        ArrayList<RoutingError> routingErrors = new ArrayList<RoutingError>();
        Set<Vertex> from = arriveBy ? this.toVertices : this.fromVertices;
        Set<Vertex> set = to = arriveBy ? this.fromVertices : this.toVertices;
        if (this.opt.from().isSpecified() && this.isDisconnected(from, true)) {
            routingErrors.add(new RoutingError(this.getRoutingErrorCodeForDisconnected(this.opt.from()), InputField.FROM_PLACE));
        }
        if (this.opt.to().isSpecified() && this.isDisconnected(to, false)) {
            routingErrors.add(new RoutingError(this.getRoutingErrorCodeForDisconnected(this.opt.to()), InputField.TO_PLACE));
        }
        if (from != null && to != null && !Sets.intersection(from, to).isEmpty()) {
            routingErrors.add(new RoutingError(RoutingErrorCode.WALKING_BETTER_THAN_TRANSIT, null));
        }
        if (!routingErrors.isEmpty()) {
            throw new RoutingValidationException(routingErrors);
        }
    }

    private boolean isDisconnected(Set<Vertex> vertices, boolean isFrom) {
        if (vertices == null) {
            return true;
        }
        Predicate<Vertex> isNotTransit = Predicate.not(TransitStopVertex.class::isInstance);
        Predicate<Vertex> hasNoIncoming = v -> v.getIncoming().isEmpty();
        Predicate<Vertex> hasNoOutgoing = v -> v.getOutgoing().isEmpty();
        Predicate<Vertex> isNotConnected = isFrom == this.opt.arriveBy() ? hasNoIncoming : hasNoOutgoing;
        return vertices.stream().allMatch(isNotTransit.and(isNotConnected));
    }

    private RoutingErrorCode getRoutingErrorCodeForDisconnected(GenericLocation location) {
        Coordinate coordinate = location.getCoordinate();
        GeometryFactory gf = GeometryUtils.getGeometryFactory();
        return coordinate != null && this.graph.getConvexHull().disjoint((Geometry)gf.createPoint(coordinate)) ? RoutingErrorCode.OUTSIDE_BOUNDS : RoutingErrorCode.LOCATION_NOT_FOUND;
    }
}

