/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.core;

import org.opentripplanner.routing.core.AStarRequest;
import org.opentripplanner.routing.core.CarPickupState;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.routing.core.VehicleRentalState;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.vehicle_rental.RentalVehicleType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateEditor {
    private static final Logger LOG = LoggerFactory.getLogger(StateEditor.class);
    protected State child;
    private boolean spawned = false;
    private boolean defectiveTraversal = false;
    private boolean traversingBackward;

    public StateEditor(Vertex v, AStarRequest request) {
        this.child = new State(v, request);
    }

    public StateEditor(State parent, Edge e) {
        this.child = parent.clone();
        this.child.backState = parent;
        this.child.backEdge = e;
        this.child.next = null;
        Vertex parentVertex = parent.vertex;
        if (e == null) {
            this.child.backState = null;
            this.child.vertex = parentVertex;
            this.child.stateData = this.child.stateData.clone();
            return;
        }
        Vertex fromVertex = e.getFromVertex();
        Vertex toVertex = e.getToVertex();
        if (fromVertex == null || toVertex == null) {
            this.child.vertex = parentVertex;
            this.child.stateData = this.child.stateData.clone();
            LOG.error("From or to vertex is null for {}", (Object)e);
            this.defectiveTraversal = true;
            return;
        }
        if (parentVertex.equals(fromVertex)) {
            this.traversingBackward = fromVertex.equals(toVertex) && parent.getRequest().arriveBy();
            this.child.vertex = toVertex;
        } else if (parentVertex.equals(toVertex)) {
            this.traversingBackward = true;
            this.child.vertex = fromVertex;
        } else {
            LOG.warn("Edge is not connected to parent state: {}", (Object)e);
            LOG.warn("   from   vertex: {}", (Object)fromVertex);
            LOG.warn("   to     vertex: {}", (Object)toVertex);
            LOG.warn("   parent vertex: {}", (Object)parentVertex);
            this.defectiveTraversal = true;
        }
        if (this.traversingBackward != parent.getRequest().arriveBy()) {
            LOG.error("Actual traversal direction does not match traversal direction in TraverseOptions.");
            this.defectiveTraversal = true;
        }
    }

    public State makeState() {
        if (this.spawned) {
            throw new IllegalStateException("A StateEditor can only be used once.");
        }
        if (this.defectiveTraversal) {
            LOG.error("Defective traversal flagged on edge " + this.child.backEdge);
            return null;
        }
        if (this.child.backState != null) {
            this.child.checkNegativeWeight();
            if (this.traversingBackward ? this.child.getTimeDeltaSeconds() > 0 : this.child.getTimeDeltaSeconds() < 0) {
                LOG.trace("Time was incremented the wrong direction during state editing. {}", (Object)this.child.backEdge);
                return null;
            }
        }
        this.spawned = true;
        return this.child;
    }

    public String toString() {
        return "StateEditor{" + this.child + "}";
    }

    public void incrementWeight(double weight) {
        if (Double.isInfinite(weight) || Double.isNaN(weight)) {
            LOG.warn("A state's weight is being incremented by " + weight + " while traversing edge " + this.child.backEdge);
            this.defectiveTraversal = true;
            return;
        }
        if (weight < 0.0) {
            LOG.warn("A state's weight is being incremented by a negative amount while traversing edge " + this.child.backEdge);
            this.defectiveTraversal = true;
            return;
        }
        this.child.weight += weight;
    }

    public void incrementTimeInSeconds(int seconds) {
        if (seconds < 0) {
            LOG.warn("A state's time is being incremented by a negative amount while traversing edge " + this.child.getBackEdge());
            this.defectiveTraversal = true;
            return;
        }
        this.child.time = this.child.time + (long)(this.traversingBackward ? -seconds : seconds);
    }

    public void incrementWalkDistance(double length) {
        if (length < 0.0) {
            LOG.warn("A state's walk distance is being incremented by a negative amount.");
            this.defectiveTraversal = true;
            return;
        }
        this.child.walkDistance += length;
    }

    public void resetEnteredNoThroughTrafficArea() {
        if (!this.child.stateData.enteredNoThroughTrafficArea) {
            return;
        }
        this.cloneStateDataAsNeeded();
        this.child.stateData.enteredNoThroughTrafficArea = false;
    }

    public void setEnteredNoThroughTrafficArea() {
        if (this.child.stateData.enteredNoThroughTrafficArea) {
            return;
        }
        this.cloneStateDataAsNeeded();
        this.child.stateData.enteredNoThroughTrafficArea = true;
    }

    public void setBackMode(TraverseMode mode) {
        if (mode == this.child.stateData.backMode) {
            return;
        }
        this.cloneStateDataAsNeeded();
        this.child.stateData.backMode = mode;
    }

    public void setBackWalkingBike(boolean walkingBike) {
        if (walkingBike == this.child.stateData.backWalkingBike) {
            return;
        }
        this.cloneStateDataAsNeeded();
        this.child.stateData.backWalkingBike = walkingBike;
    }

    public void beginFloatingVehicleRenting(RentalVehicleType.FormFactor formFactor, String network, boolean reverse) {
        this.cloneStateDataAsNeeded();
        if (reverse) {
            this.child.stateData.vehicleRentalState = VehicleRentalState.BEFORE_RENTING;
            this.child.stateData.currentMode = TraverseMode.WALK;
            this.child.stateData.vehicleRentalNetwork = null;
            this.child.stateData.rentalVehicleFormFactor = null;
        } else {
            this.child.stateData.vehicleRentalState = VehicleRentalState.RENTING_FLOATING;
            this.child.stateData.currentMode = formFactor.traverseMode;
            this.child.stateData.vehicleRentalNetwork = network;
            this.child.stateData.rentalVehicleFormFactor = formFactor;
        }
    }

    public void beginVehicleRentingAtStation(RentalVehicleType.FormFactor formFactor, String network, boolean mayKeep, boolean reverse) {
        this.cloneStateDataAsNeeded();
        if (reverse) {
            this.child.stateData.mayKeepRentedVehicleAtDestination = mayKeep;
            this.child.stateData.vehicleRentalState = VehicleRentalState.BEFORE_RENTING;
            this.child.stateData.currentMode = TraverseMode.WALK;
            this.child.stateData.vehicleRentalNetwork = null;
            this.child.stateData.rentalVehicleFormFactor = null;
            this.child.stateData.backWalkingBike = false;
        } else {
            this.child.stateData.mayKeepRentedVehicleAtDestination = mayKeep;
            this.child.stateData.vehicleRentalState = VehicleRentalState.RENTING_FROM_STATION;
            this.child.stateData.currentMode = formFactor.traverseMode;
            this.child.stateData.vehicleRentalNetwork = network;
            this.child.stateData.rentalVehicleFormFactor = formFactor;
        }
    }

    public void dropOffRentedVehicleAtStation(RentalVehicleType.FormFactor formFactor, String network, boolean reverse) {
        this.cloneStateDataAsNeeded();
        if (reverse) {
            this.child.stateData.mayKeepRentedVehicleAtDestination = false;
            this.child.stateData.vehicleRentalState = VehicleRentalState.RENTING_FROM_STATION;
            this.child.stateData.currentMode = formFactor.traverseMode;
            this.child.stateData.vehicleRentalNetwork = network;
            this.child.stateData.rentalVehicleFormFactor = formFactor;
        } else {
            this.child.stateData.mayKeepRentedVehicleAtDestination = false;
            this.child.stateData.vehicleRentalState = VehicleRentalState.HAVE_RENTED;
            this.child.stateData.currentMode = TraverseMode.WALK;
            this.child.stateData.vehicleRentalNetwork = null;
            this.child.stateData.rentalVehicleFormFactor = null;
            this.child.stateData.backWalkingBike = false;
        }
    }

    public void setVehicleParked(boolean vehicleParked, TraverseMode nonTransitMode) {
        this.cloneStateDataAsNeeded();
        this.child.stateData.vehicleParked = vehicleParked;
        this.child.stateData.currentMode = nonTransitMode;
    }

    public void setFromState(State state) {
        this.cloneStateDataAsNeeded();
        this.child.stateData.currentMode = state.stateData.currentMode;
        this.child.stateData.carPickupState = state.stateData.carPickupState;
        this.child.stateData.vehicleParked = state.stateData.vehicleParked;
        this.child.stateData.backWalkingBike = state.stateData.backWalkingBike;
    }

    public void setCarPickupState(CarPickupState carPickupState) {
        this.cloneStateDataAsNeeded();
        this.child.stateData.carPickupState = carPickupState;
        switch (carPickupState) {
            case WALK_TO_PICKUP: 
            case WALK_FROM_DROP_OFF: {
                this.child.stateData.currentMode = TraverseMode.WALK;
                break;
            }
            case IN_CAR: {
                this.child.stateData.currentMode = TraverseMode.CAR;
            }
        }
    }

    public void setTimeSeconds(long seconds) {
        this.child.time = seconds;
    }

    public State getBackState() {
        return this.child.getBackState();
    }

    private void cloneStateDataAsNeeded() {
        if (this.child.backState != null && this.child.stateData == this.child.backState.stateData) {
            this.child.stateData = this.child.stateData.clone();
        }
    }
}

