/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.core;

import java.util.ArrayList;
import java.util.List;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.core.AStarRequest;
import org.opentripplanner.routing.core.CarPickupState;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.routing.core.VehicleRentalState;
import org.opentripplanner.routing.vehicle_rental.RentalVehicleType;

public class StateData
implements Cloneable {
    protected boolean vehicleParked;
    protected VehicleRentalState vehicleRentalState;
    protected boolean mayKeepRentedVehicleAtDestination;
    protected CarPickupState carPickupState;
    protected TraverseMode currentMode;
    protected TraverseMode backMode;
    protected boolean backWalkingBike;
    public String vehicleRentalNetwork;
    public RentalVehicleType.FormFactor rentalVehicleFormFactor;
    protected boolean enteredNoThroughTrafficArea;

    private StateData(StreetMode requestMode) {
        this.currentMode = requestMode.includesDriving() ? TraverseMode.CAR : (requestMode.includesWalking() ? TraverseMode.WALK : (requestMode.includesBiking() ? TraverseMode.BICYCLE : null));
    }

    public static List<StateData> getInitialStateDatas(AStarRequest request) {
        return StateData.getInitialStateDatas(request.mode(), request.arriveBy(), request.rental().allowArrivingInRentedVehicleAtDestination(), false);
    }

    public static StateData getInitialStateData(AStarRequest request) {
        List<StateData> stateDatas = StateData.getInitialStateDatas(request.mode(), request.arriveBy(), request.rental().allowArrivingInRentedVehicleAtDestination(), true);
        if (stateDatas.size() != 1) {
            throw new IllegalStateException("Unable to create only a single state");
        }
        return stateDatas.get(0);
    }

    private static List<StateData> getInitialStateDatas(StreetMode requestMode, boolean arriveBy, boolean allowArrivingInRentedVehicleAtDestination, boolean forceSingleState) {
        ArrayList<StateData> res = new ArrayList<StateData>();
        StateData proto = new StateData(requestMode);
        if (requestMode.includesPickup()) {
            if (!forceSingleState) {
                StateData inCarPickupStateData = proto.clone();
                inCarPickupStateData.carPickupState = CarPickupState.IN_CAR;
                inCarPickupStateData.currentMode = TraverseMode.CAR;
                res.add(inCarPickupStateData);
            }
            StateData walkingPickupStateData = proto.clone();
            walkingPickupStateData.carPickupState = arriveBy ? CarPickupState.WALK_FROM_DROP_OFF : CarPickupState.WALK_TO_PICKUP;
            walkingPickupStateData.currentMode = TraverseMode.WALK;
            res.add(walkingPickupStateData);
        } else if (requestMode.includesRenting()) {
            if (arriveBy) {
                if (!forceSingleState) {
                    if (allowArrivingInRentedVehicleAtDestination) {
                        StateData keptVehicleStateData = proto.clone();
                        keptVehicleStateData.vehicleRentalState = VehicleRentalState.RENTING_FROM_STATION;
                        keptVehicleStateData.currentMode = TraverseMode.BICYCLE;
                        keptVehicleStateData.mayKeepRentedVehicleAtDestination = true;
                        res.add(keptVehicleStateData);
                    }
                    StateData floatingRentalStateData = proto.clone();
                    floatingRentalStateData.vehicleRentalState = VehicleRentalState.RENTING_FLOATING;
                    floatingRentalStateData.currentMode = TraverseMode.BICYCLE;
                    res.add(floatingRentalStateData);
                }
                StateData stationReturnedStateData = proto.clone();
                stationReturnedStateData.vehicleRentalState = VehicleRentalState.HAVE_RENTED;
                stationReturnedStateData.currentMode = TraverseMode.WALK;
                res.add(stationReturnedStateData);
            } else {
                StateData beforeRentalStateData = proto.clone();
                beforeRentalStateData.vehicleRentalState = VehicleRentalState.BEFORE_RENTING;
                res.add(beforeRentalStateData);
            }
        } else if (requestMode.includesParking()) {
            StateData parkAndRideStateData = proto.clone();
            parkAndRideStateData.vehicleParked = arriveBy;
            parkAndRideStateData.currentMode = parkAndRideStateData.vehicleParked ? TraverseMode.WALK : (requestMode.includesBiking() ? TraverseMode.BICYCLE : TraverseMode.CAR);
            res.add(parkAndRideStateData);
        } else {
            res.add(proto.clone());
        }
        return res;
    }

    public StateData clone() {
        try {
            return (StateData)super.clone();
        }
        catch (CloneNotSupportedException e1) {
            throw new IllegalStateException("This is not happening");
        }
    }
}

