/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.core;

import java.text.NumberFormat;
import java.util.Currency;
import java.util.Locale;

public record Money(Currency currency, int cents) implements Comparable<Money>
{
    public static Money euros(int cents) {
        return new Money(Currency.getInstance("EUR"), cents);
    }

    public static Money usDollars(int cents) {
        return new Money(Currency.getInstance("USD"), cents);
    }

    @Override
    public int compareTo(Money m) {
        if (m.currency != this.currency) {
            throw new RuntimeException("Can't compare " + m.currency + " to " + this.currency);
        }
        return this.cents - m.cents;
    }

    @Override
    public String toString() {
        NumberFormat nf = NumberFormat.getCurrencyInstance(Locale.ENGLISH);
        nf.setCurrency(this.currency);
        nf.setMaximumFractionDigits(this.currency.getDefaultFractionDigits());
        return nf.format((double)this.cents / Math.pow(10.0, this.currency.getDefaultFractionDigits()));
    }
}

